
/************************************************************************
 *                                                                      *
 * ODBC Simple Wrapper V2.0                                             *
 * Copyright (C) 2009 Claudio Rocchini                                  *
 * Istituto Geografico Militare Italiano                                *
 * web:   www.igmi.org                                                  *
 * email: ad2prod@geomil.esercito.difesa.it                             *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the  Free Software Foundation, either  version 3 of the  License, or *
 * any later version.                                                   *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without  even the implied warranty of    *
 *   MERCHANTABILITY or  FITNESS  FOR A PARTICULAR PURPOSE.  See the    *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program.  If not, see <http://www.gnu.org/licenses/> *
 *                                                                      *
 ************************************************************************/


#ifndef __SHQN__RODBC2__
#define __SHQN__RODBC2__


#include <windows.h>
#include <sql.h>
#include <sqlext.h>
#include <string>
#include <vector>


namespace sql2
{


class Driver
{
public:
	std::string name;
	std::vector< std::string > params;
};

	
class Environment
{
protected:
	SQLRETURN status;
	SQLHENV   handle;
public:
	Environment();
	~Environment();

	SQLHENV   get_handle() const;
	SQLRETURN get_status() const;
	void      get_message( char * message ) const;
	bool      set_attrib( SQLINTEGER attrib, int value );
	bool      set_attrib( SQLINTEGER attrib, char * value );
	bool      get_drivers( std::vector<Driver> & drivers ) const;
	bool      get_data_source( std::vector< std::string > & sources ) const;
};

	
class Connection
{
protected:
	SQLHDBC   handle;
	SQLRETURN status;
	bool      connected;
	const Environment * envp;

public:
	Connection( const Environment & env );
	~Connection();
	
	SQLHENV   get_handle() const;
	SQLRETURN get_status() const;
	bool      is_connected() const;
	void      get_message( char * message ) const;
	bool      connect(const char * conn, int mode = SQL_MODE_READ_ONLY );
	bool      connect_file(const char * type, const char * filename, 
		                   int mode = SQL_MODE_READ_ONLY, const char * passw=0  );
	void      disconnect();
	bool      set_attrib( SQLINTEGER attrib, int value );
	bool      set_attrib( SQLINTEGER attrib, char * value );
};


class Column
{
public:
	std::string name;
	SQLSMALLINT type;
	SQLUINTEGER size;
	SQLSMALLINT decimal;
	SQLSMALLINT nullable;
};


class ColumnDesc
{
public:
	std::string catalog;
	std::string schema;
	std::string table;
	std::string name;
	std::string desc;
	long        type;
	std::string type_name;
	std::string size;
	std::string buffer_size;
	std::string digit;

	std::string radix;
	std::string nullable;
	std::string remark;
	std::string default_value;
};


class TableDesc
{
public:
	std::string catalog;
	std::string schema;
	std::string name;
	std::string type;
	std::string desc;
};


class Statement
{
protected:
	SQLHSTMT handle;
	SQLRETURN status;

public:
	Statement( const Connection & con );
	~Statement();

	SQLHENV   get_handle() const;
	SQLRETURN get_status() const;
	void      get_message( char * message ) const;
	bool      set_attrib( SQLINTEGER attrib, int value );
	bool      set_attrib( SQLINTEGER attrib, char * value );

	bool execute( const char * query );
	void close_cursor();
	SQLRETURN fetch();
	int  get_num_cols() const;
	bool describe_col( int num, Column & c) const;
	bool cancel();

	bool bind( int num_col, long & data );
	bool bind( int num_col, unsigned long & data );
	bool bind( int num_col, short & data );
	bool bind( int num_col, unsigned short & data );
	bool bind( int num_col, float & data );
	bool bind( int num_col, double & data );

		// For nullable columns: lenght show if field is filled

	bool bind( int num_col, long & data,           long & lenght );
	bool bind( int num_col, unsigned long & data,  long & lenght );
	bool bind( int num_col, short & data,          long & lenght );
	bool bind( int num_col, unsigned short & data, long & lenght );
	bool bind( int num_col, float & data,          long & lenght );
	bool bind( int num_col, double & data,         long & lenght );

	bool bind( int num_col, char * data, int size, long & lenght );	// Testo
	bool bind( int num_col, void * data, int size, long & lenght );	// Binario
    bool bind( int num_col, TIMESTAMP_STRUCT & tm, long & lenght );

	bool unbind();
	bool tables( std::vector< TableDesc > & tables );
	bool columns( const char * table, std::vector< ColumnDesc > & cols );
};


	// Implementation

#include "rodbc2.inl"

}	// End namespace sql2


#endif
