#!/usr/sbin/dtrace -qs

/*
 * Usage      : disk_io.d
 * Description: Show disk I/O activity by device, file, type (RW), and size
 * Author     : Robert Lor
 */

BEGIN
{
	printf("%10s %65s %2s %4s\n", "DEVICE", "FILE", "RW", "BYTES");

	endtime = timestamp + (5 * 1000000000ull);
}

io:::start
{
	start[args[0]->b_edev, args[0]->b_blkno] = timestamp;
}

io:::done
/start[args[0]->b_edev, args[0]->b_blkno]/
{
	this->elapsed = timestamp - start[args[0]->b_edev, args[0]->b_blkno];
	printf("%10s %65s %2s %4d\n", args[1]->dev_statname,
	    args[2]->fi_pathname, args[0]->b_flags & B_READ ? "R" : "W", args[0]->b_bcount);
	start[args[0]->b_edev, args[0]->b_blkno] = 0;
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
	exit(0);
}
