<?php 
require_once ('include/define.inc');
require_once ('./lib/htmltemplate.inc');
require_once ('./lib/DBAccess.inc');
require_once ("HTML/Table.php");

function xpatheval($sql) 
{
	$GLOBALS['logger'] -> log('entering xpath_eval()', PEAR_LOG_DEBUG);
	static $stmt;
	$dba = & DBAccess::getInstance();
	
	$pieces = explode(';',$sql);
	$len = count($pieces)-1;

	if($len > 0)
	{
		for($i=0; $i<$len; $i++){
			if (ENV_DEBUG) echo $pieces[$i];
			$GLOBALS['logger'] -> log($pieces[$i], PEAR_LOG_INFO);
			$dba->query($pieces[$i]);
		}
		$sql = $pieces[$i];
	}
	$GLOBALS['logger'] -> log($sql, PEAR_LOG_INFO);
	$result = $dba -> getAll($sql);

	if($result==NULL)
		die('no result');

	// Always check that $result is not an error
	if (DB :: isError($result))
		die($result -> getMessage());

	$GLOBALS['logger'] -> log('returning xpath_eval()', PEAR_LOG_DEBUG);
	return $result;
}

function genTable($result) 
{
	$GLOBALS['logger'] -> log('entering genTable()', PEAR_LOG_DEBUG);
	$tableStyle = array(
						"bgcolor" => "#FFFFFF", 
						"border" => 1, 
						"width" => "90%", 
						"cellpadding" => 1, 
						"cellspacing" => 2
					);
	$table = new HTML_Table($tableStyle);
	$colHeaders = array("docid", "result"); 
	$table->addRow($colHeaders);
	$table->setRowAttributes(0,"bgcolor=#99CCCC");
	//$table->setColAttributes(1,"bgcolor=#99CCCC align=right");
	foreach($result as $row)
		$table->addRow(array(htmlspecialchars($row[0]),htmlspecialchars($row[1])));

	$row1Style = "bgcolor=#FFFFCC align=left";
	$row2Style = array ("bgcolor" => "#FFFF99", "align"=>"left");
	$table->altRowAttributes(1,$row1Style,$row2Style);
 
	$GLOBALS['logger'] -> log('returning genTable()', PEAR_LOG_DEBUG);
	return $table;
}

function outputHTML($argv) {
	$GLOBALS['logger'] -> log('entering outputHTML()', PEAR_LOG_DEBUG);
	HtmlTemplate :: t_include('./views/result.tpl.html', $argv);
}

function init() {
	$GLOBALS['logger'] -> log("-- (${_SERVER['PHP_SELF']})", PEAR_LOG_DEBUG);
	$GLOBALS['logger'] -> log('entering init()', PEAR_LOG_DEBUG);
	if (ENV_DEBUG) print_r($_POST);
	if (isset($_POST['sql']))
		$sql = $_POST['sql'];
	else
		die('paramator sql is missing.');
	$result =& xpatheval($sql);
	$tbl =& genTable($result);
	//print_r($tbl);
	$argv['vars']['tbl'] =&$tbl->toHTML();
	//if (ENV_DEBUG) print_r($argv);
	outputHTML($argv);
}

init();

?>