#!/bin/bash
 
# default setting
PGSRC=/usr/local/src/postgres/postgresql-7.4.1

# check user
if [ `id -u` -ne 0 ];then
	echo 'This command in only executed by root'
    exit 1
fi

echo
echo '----- Input your postgres src dirname -----'
echo "default is setted to.. ${PGSRC}"
echo 'press just enter to start with default setting.'
echo
echo 'please input > ' 
read INPUT

if [ -n "$INPUT" ]; then
	echo "postgres src directory is setted to ${INPUT}"
	PGSRC=$INPUT
else
	echo 'continue with default setting..'
fi

if [ ! -d "$PGSRC" ]; then
	echo
	echo "postgres src directory ${PGSRC} is not found."
	echo 'you have to specify the valid path to pgsrc dir.'
	echo
	exit 1;
fi

echo
echo "PGSRC is setted to ${PGSRC}"
echo 'setting is ok ? continue setting ?'
select input in yes no
do
	case $input in
	    'yes')
			break
			;;
	    'no')
	    	echo
	        echo 'quit'
	        exit 1;
	        break
	        ;;
	    *)
	        echo 'input argument is invalid'
	        echo 'please choose number.'
	        ;;
	esac
done

TARGET=$PGSRC/contrib/intarray

echo
echo 'backup old intarray to intarray.old'
rm -rf ${PGSRC}/contrib/intarray.old
cp -R ${PGSRC}/contrib/intarray ${PGSRC}/contrib/intarray.old

echo
echo "copy files to ${TARGET}"
cp _int_add.sql _int_dewey.c create.sh Makefile ${TARGET}

echo 'prepared !'

sleep 3

echo
echo 'start setting database'
echo
./create.sh ${TARGET}

echo 'finish !'