/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS BuildConfigFile v 0.1
* Descripcion:
* Esta clase tiene la responsabilidad de modificar el archivo de    
* configuracin de la aplicacin. En este archivo se guardan los    
* datos de conexiones exitosas pasadas con una bandera de true sobre
* la ltima conexin utilizada.                                     
* Los objetos de este tipo se crean desde la clase XPg.             
* 
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*
* Fecha: 2001/10/01
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws
*          Gustavo Gonzalez - xtingray@kazak.ws
*/

import java.io.*;
import java.util.Vector;

public class BuildConfigFile {

 PrintStream configFile;
 int pos;

 /**
  * METODO CONSTRUCTOR, 1ra. Opcin
  * Escribe de nuevo el archivo de configuracin cambiando la bandera 
  * que indica cual fue el registro que logr la ltima conexin
  */
 public BuildConfigFile(Vector ListRegs,int num, String idiom) 
 {
  pos = num;
  init();
  configFile.println("language=" + idiom);     
  for(int i=0;i<ListRegs.size();i++)
   {
     boolean onlyone;
     ConRegister tmp = (ConRegister) ListRegs.elementAt(i); 
     configFile.println("server=" + tmp.Hostname);
     configFile.println("database=" + tmp.Database);
     configFile.println("username=" + tmp.Username);
     configFile.println("port=" + tmp.Port);
     if(i==pos)
      onlyone = true;
     else
      onlyone = false;

     configFile.println("last=" + onlyone); 
   }
     configFile.close();
 }

 /**
  * METODO CONSTRUCTOR, 2da. Opcin
  * Escribe de nuevo el archivo de configuracin agregando los 
  * datos de una nueva configuracin exitosa.
  */
 public BuildConfigFile(Vector ListRegs,ConRegister online, String idiom) 
  {
    init();
    configFile.println("language=" + idiom);     
    for(int i=0;i<ListRegs.size();i++)
       {
         boolean onlyone;
         ConRegister tmp = (ConRegister) ListRegs.elementAt(i);
         configFile.println("server=" + tmp.Hostname);
         configFile.println("database="+tmp.Database);
         configFile.println("username=" + tmp.Username);
	      configFile.println("port=" + tmp.Port);
         configFile.println("last=false");
       }
    configFile.println("server=" + online.Hostname);
    configFile.println("database="+ online.Database);
    configFile.println("username=" + online.Username);
    configFile.println("port=" + online.Port);
    configFile.println("last=true");
    configFile.close();
 }

 /**
  * Mtodo init
  * Abre el archivo de configuracin para escritura
  */
 public void init() 
 {
  try {
        String configPath = "xpg.cfg";
        String OS = System.getProperty("os.name");
        if(OS.equals("Linux") || OS.equals("Solaris") || OS.equals("FreeBSD"))
          {
            String UHome = System.getProperty("user.home");
            configPath = UHome + System.getProperty("file.separator")
                         + ".xpg" + System.getProperty("file.separator") + "xpg.cfg";
          }
        if(OS.startsWith("Windows"))
          {
            String xpgHome = System.getProperty("xpgHome");
            configPath = xpgHome + System.getProperty("file.separator") + "xpg.cfg";
          }

          configFile = new PrintStream(
	       new FileOutputStream(configPath));
      }
  catch(Exception ex)
      {
          System.out.println("Error: " + ex);
          ex.printStackTrace();
      }
 }

}
