#define	BUFFER_SIZE 256
//------------------------------------------------------------------------------
class ConsoleRedirector
{
public:
	ConsoleRedirector();
	~ConsoleRedirector();

	BOOL IsChildRunning() const;
	BOOL StartChildProcess(LPCSTR lpszCmdLine, LPCSTR lpszExecDir, BOOL bShowChildWindow = FALSE);
	void Cleanup();

	// Overload these to change functionality
	virtual void OnChildWrite(LPCSTR lpszOutput);
	virtual void OnChildStarted(LPCSTR lpszCmdLine);
	virtual void OnChildStdOut(LPCSTR lpszOutput);
	virtual void OnChildStdErr(LPCSTR lpszOutput);
	virtual void OnChildTerminate();
	
protected:
	BOOL bRunThread;
	// Child process handle
	HANDLE hChildProcess;
	// Child input(stdin) & output(stdout, stderr) pipes
	HANDLE hStdIn, hStdOut, hStdErr;
	// Parent output(stdin) & input(stdout) pipe
	HANDLE hStdInWrite, hStdOutRead, hStdErrRead;
	// stdout, stderr write threads
	HANDLE hStdOutThread, hStdErrThread;
	// child process monitoring thread
	HANDLE hProcessThread;
	//--------------------------------
	BOOL CreatePipes();
	BOOL CloseChildHandles();
	BOOL CloseHandles();
	BOOL CreateThreads();
	HANDLE CreateChildProcess(LPCSTR lpszCmdLine, LPCSTR lpszExecDir, BOOL bShowChildWindow);

	// Handlers
	virtual	int StdOutThread();
	virtual int StdErrThread();
	virtual int ProcessThread();
	
	// Thunks
	static int _StdOutThread(ConsoleRedirector *p) { return p->StdOutThread(); }
	static int _StdErrThread(ConsoleRedirector *p) { return p->StdErrThread(); }
	static int _ProcessThread(ConsoleRedirector *p) { return p->ProcessThread(); }
};
//------------------------------------------------------------------------------
