/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleTableSlot;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SingleRowReader
extends SingleRowResultSet {
    private final Tuple m_tuple;

    public SingleRowReader(TupleTableSlot tableSlot) throws SQLException {
        super(tableSlot.getTupleDesc());
        this.m_tuple = tableSlot.getTuple();
    }

    protected Object getObjectValue(int columnIndex) throws SQLException {
        return this.m_tuple.getObject(this.getTupleDesc(), columnIndex);
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public void cancelRowUpdates() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void deleteRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void insertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void moveToInsertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void updateRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    private static SQLException readOnlyException() {
        return new UnsupportedFeatureException("ResultSet is read-only");
    }
}

