/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.internal.TypeMap;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;

public class SPIResultSetMetaData
extends AbstractResultSetMetaData {
    private final TupleDesc m_tupleDesc;

    public SPIResultSetMetaData(TupleDesc tupleDesc) {
        this.m_tupleDesc = tupleDesc;
    }

    public final int getColumnCount() throws SQLException {
        return this.m_tupleDesc.size();
    }

    public final boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public final String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.m_tupleDesc.getColumnName(n).toUpperCase();
    }

    public final String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return TypeMap.getClassNameFromPgOid(this.getOid(n));
    }

    protected final void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.m_tupleDesc.size()) {
            throw new SQLException("Invalid column index: " + n);
        }
    }

    protected final int getOid(int n) throws SQLException {
        return this.m_tupleDesc.getOid(n);
    }

    protected final int getFieldLength(int n) throws SQLException {
        return 0;
    }
}

