/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import org.postgresql.pljava.internal.ExecutionPlan;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIParameterMetaData;
import org.postgresql.pljava.jdbc.SPIStatement;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIPreparedStatement
extends SPIStatement
implements PreparedStatement {
    private static final Object s_undef = new Object();
    private final String m_statement;
    private final int m_paramCount;
    private final ArrayList m_paramList;
    private ExecutionPlan m_plan;
    private int[] m_sqlTypes;
    private Oid[] m_typeIds;

    public SPIPreparedStatement(SPIConnection sPIConnection, String string, int n) {
        super(sPIConnection);
        this.m_statement = string;
        this.m_paramCount = n;
        this.m_paramList = new ArrayList(this.m_paramCount);
    }

    public void close() {
        if (this.m_plan != null) {
            this.m_plan.invalidate();
            this.m_plan = null;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.getResultSet();
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setObject(n, null, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setObject(n, (Object)(bl ? Boolean.TRUE : Boolean.FALSE), 16);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setObject(n, (Object)new Byte(by), -6);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setObject(n, (Object)new Short(s), 5);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setObject(n, (Object)new Integer(n2), 4);
    }

    public void setLong(int n, long l) throws SQLException {
        this.setObject(n, (Object)new Long(l), -5);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setObject(n, (Object)new Float(f), 6);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setObject(n, (Object)new Double(d), 8);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setObject(n, (Object)bigDecimal, 3);
    }

    public void setString(int n, String string) throws SQLException {
        this.setObject(n, (Object)string, 12);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setObject(n, (Object)byArray, -3);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setObject(n, (Object)date, 91);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setObject(n, (Object)time, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setObject(n, (Object)timestamp, 93);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.m_paramList.add(new ParamEntry(n, 2005, new ClobValue(new InputStreamReader(inputStream, "US-ASCII"), n2)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedFeatureException("PreparedStatement.setUnicodeStream");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setObject(n, (Object)new BlobValue(inputStream, n2), 2004);
    }

    public void clearParameters() throws SQLException {
        this.m_paramList.clear();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (n < 1 || n > this.m_paramCount) {
            throw new SQLException("Illegal parameter index");
        }
        this.m_paramList.add(new ParamEntry(n - 1, n2, object));
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            throw new SQLException("Can't assign null unless the SQL type is known");
        }
        this.setObject(n, object, SPIConnection.getTypeForClass(object.getClass()));
    }

    private int[] getSqlTypes() {
        if (this.m_sqlTypes != null) {
            return this.m_sqlTypes;
        }
        int n = this.m_paramList.size();
        int[] nArray = new int[this.m_paramCount];
        Arrays.fill(nArray, 12);
        for (int i = 0; i < n; ++i) {
            ParamEntry paramEntry = (ParamEntry)this.m_paramList.get(i);
            nArray[paramEntry.getIndex()] = paramEntry.getSqlType();
        }
        this.m_sqlTypes = nArray;
        return nArray;
    }

    public boolean execute() throws SQLException {
        int n;
        Object object;
        int n2;
        Object[] objectArray = null;
        ArrayList arrayList = this.m_paramList;
        int n3 = arrayList.size();
        if (n3 < this.m_paramCount) {
            throw new SQLException("Not all parameters have been set");
        }
        if (n3 > 0) {
            objectArray = new Object[this.m_paramCount];
            Arrays.fill(objectArray, s_undef);
            for (n2 = 0; n2 < n3; ++n2) {
                object = (ParamEntry)arrayList.get(n2);
                n = ((ParamEntry)object).getIndex();
                if (objectArray[n] != s_undef) {
                    throw new SQLException("Parameter with index " + (n2 + 1) + " was set more than once");
                }
                objectArray[n] = ((ParamEntry)object).getValue();
            }
        }
        if (this.m_plan == null) {
            if (this.m_typeIds == null && n3 > 0) {
                int[] nArray = new int[n3];
                object = new Oid[n3];
                for (n = 0; n < n3; ++n) {
                    ParamEntry paramEntry = (ParamEntry)arrayList.get(n);
                    int n4 = paramEntry.getIndex();
                    nArray[n4] = paramEntry.getSqlType();
                    object[n4] = paramEntry.getTypeId();
                }
                this.m_sqlTypes = nArray;
                this.m_typeIds = object;
            }
            this.m_plan = ExecutionPlan.prepare(this.m_statement, this.m_typeIds);
            this.m_plan.makeDurable();
        }
        n2 = this.executePlan(this.m_plan, objectArray);
        arrayList.clear();
        return n2 != 0;
    }

    public boolean execute(String string) throws SQLException {
        throw new UnsupportedFeatureException("Can't execute other statements using a prepared statement");
    }

    public void addBatch() throws SQLException {
        this.internalAddBatch(this.m_paramList.clone());
        this.m_paramList.clear();
    }

    public void addBatch(String string) throws SQLException {
        throw new UnsupportedFeatureException("Can't add batch statements to a prepared statement");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setObject(n, (Object)new ClobValue(reader, n2), 2005);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.setObject(n, (Object)ref, 2006);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setObject(n, (Object)blob, 2004);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setObject(n, (Object)clob, 2005);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.setObject(n, (Object)array, 2003);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (calendar == null || calendar == Calendar.getInstance()) {
            this.setObject(n, (Object)date, 91);
        }
        throw new UnsupportedFeatureException("Setting date using explicit Calendar");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (calendar == null || calendar == Calendar.getInstance()) {
            this.setObject(n, (Object)time, 92);
        }
        throw new UnsupportedFeatureException("Setting time using explicit Calendar");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (calendar == null || calendar == Calendar.getInstance()) {
            this.setObject(n, (Object)timestamp, 93);
        }
        throw new UnsupportedFeatureException("Setting time using explicit Calendar");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.setObject(n, (Object)uRL, 70);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new SPIParameterMetaData(this.getSqlTypes());
    }

    protected int executeBatchEntry(Object object) throws SQLException {
        int n = -2;
        this.m_paramList.clear();
        this.m_paramList.addAll((ArrayList)object);
        if (this.execute()) {
            this.getResultSet().close();
        } else {
            int n2 = this.getUpdateCount();
            if (n2 >= 0) {
                n = n2;
            }
        }
        return n;
    }

    public static class ParamEntry {
        private final int m_columnIndex;
        private final int m_sqlType;
        private final Object m_value;

        ParamEntry(int n, int n2, Object object) {
            this.m_columnIndex = n;
            this.m_sqlType = n2;
            this.m_value = object;
        }

        int getIndex() {
            return this.m_columnIndex;
        }

        int getSqlType() {
            return this.m_sqlType;
        }

        Oid getTypeId() {
            Oid oid;
            Oid oid2 = oid = this.m_sqlType == 1111 ? Oid.forJavaClass(this.m_value.getClass()) : Oid.forSqlType(this.m_sqlType);
            if (oid == null) {
                oid = Oid.forSqlType(12);
            }
            return oid;
        }

        Object getValue() {
            return this.m_value;
        }
    }
}

