/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.pljava.test.CommandReader;
import org.postgresql.pljava.test.Environment;
import org.postgresql.pljava.test.Path;

public class TestPLJava {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_PGSQLHOME = 0;
    private static final int CMD_TESTDIR = 1;
    private static final int CMD_PORT = 2;
    private static final int CMD_WINDOWS = 3;
    private static final ArrayList s_commands = new ArrayList();
    private final File m_pgsqlHome;
    private final File m_pljavaHome;
    private final File m_pljavaBin;
    private final File m_testHome;
    private final int m_majorVer;
    private final int m_minorVer;

    private static final int getCommand(String string) {
        int n = s_commands.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!((String)s_commands.get(i)).startsWith(string)) continue;
            if (n2 != -1) {
                return -2;
            }
            n2 = i;
        }
        return n2;
    }

    public static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("usage: java org.postgresql.pljava.test.TestPLJava");
        printStream.println("    [ -port <number>     ]    # default is 5432");
        printStream.println("    [ -pgsqlhome <dir>   ]    # default is /usr/local/pgsql");
        printStream.println("    [ -testdir <dir>     ]    # default is current directory");
        printStream.println("    [ -printenv          ]    # print the env for the postmaster");
        printStream.println("    [ -windows ]              # If the server is on a Windows machine");
    }

    private int[] getPostgreSQLVersion() throws IOException {
        CommandReader commandReader = CommandReader.create(new String[]{"pg_ctl", "--version"}, this.getPostgresEnvironment().asArray());
        String string = commandReader.readLine();
        commandReader.close();
        int n = commandReader.getExitValue();
        if (n != 0) {
            throw new IOException("pg_ctl exit value " + n);
        }
        Pattern pattern = Pattern.compile("\\D+(\\d+)\\.(\\d+)\\D");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.lookingAt()) {
            throw new IOException("Unable to determine PostgreSQL version from " + string);
        }
        return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))};
    }

    public TestPLJava(String string, String string2) throws IOException {
        this.m_pgsqlHome = new File(string);
        this.m_pljavaHome = new File(string2);
        this.m_testHome = new File(this.m_pljavaHome, "test");
        this.m_pljavaBin = new File(new File(new File(this.m_pljavaHome, "bin"), "build"), "pljava");
        int[] nArray = this.getPostgreSQLVersion();
        this.m_majorVer = nArray[0];
        this.m_minorVer = nArray[1];
    }

    public Environment getPostgresEnvironment() throws IOException {
        Environment environment = new Environment();
        Path path = new Path(environment.get("PATH"));
        File file = new File(this.m_pgsqlHome, "bin");
        File file2 = new File(this.m_pgsqlHome, "lib");
        if (Environment.isWindows()) {
            path.addFirst(file2);
        } else {
            Path path2 = new Path(environment.get("LD_LIBRARY_PATH"));
            path2.addFirst(file2);
            environment.put("LD_LIBRARY_PATH", path2.toString());
        }
        path.addFirst(file);
        environment.put("PATH", path.toString());
        return environment;
    }

    public static void main(String[] stringArray) {
        try {
            TestPLJava testPLJava = new TestPLJava("c:\\msys\\local\\pgsql", "c:\\");
            System.out.println(testPLJava.getPostgresEnvironment());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initdb() {
    }

    static {
        s_commands.add(0, "pgsqlhome");
        s_commands.add(1, "testdir");
        s_commands.add(2, "port");
    }

    class Postmaster
    extends Thread {
        Postmaster() {
        }

        public void run() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("postmaster");
            arrayList.add("-D");
            arrayList.add(new File(TestPLJava.this.m_testHome, "db").getAbsolutePath());
            if (TestPLJava.this.m_minorVer < 5) {
                arrayList.add("-c");
                arrayList.add("tcpip_socket=true");
            } else {
                arrayList.add("-c");
                arrayList.add("custom_variable_classes=pljava");
            }
            arrayList.add("-c");
            arrayList.add("log_min_messages=debug1");
            arrayList.add("-c");
            arrayList.add("dynamic_library_path=" + TestPLJava.this.m_pljavaBin.getAbsolutePath());
            Runtime runtime = Runtime.getRuntime();
            KillPostmaster killPostmaster = new KillPostmaster();
            runtime.addShutdownHook(killPostmaster);
            try {
                runtime.exec(arrayList.toArray(new String[arrayList.size()]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            runtime.removeShutdownHook(killPostmaster);
        }
    }

    class KillPostmaster
    extends Thread {
        KillPostmaster() {
        }
    }
}

