/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.management.SQLDeploymentDescriptor;

public class Commands {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installJar(String string, String string2, boolean bl) throws SQLException {
        Commands.assertJarName(string2);
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            if (Commands.getJarId(connection, string2) >= 0) {
                throw new SQLException("A jar named '" + string2 + "' already exists");
            }
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO sqlj.jar_repository(jarName, jarOrigin) VALUES(?, ?)");
            try {
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new SQLException("Jar repository insert did not insert 1 row");
                }
            }
            finally {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            int n = Commands.getJarId(connection, string2);
            if (n < 0) {
                throw new SQLException("Unable to obtain id of '" + string2 + "'");
            }
            Commands.addClassImages(connection, n, string);
            if (bl) {
                Commands.deployInstall(connection, n);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceJar(String string, String string2, boolean bl) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            int n = Commands.getJarId(connection, string2);
            if (n < 0) {
                throw new SQLException("No Jar named '" + string2 + "' is known to the system");
            }
            if (bl) {
                Commands.deployRemove(connection, n);
            }
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE sqlj.jar_repository SET jarOrigin = ?, deploymentDesc = NULL WHERE jarId = ?");
            try {
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new SQLException("Jar repository update did not update 1 row");
                }
            }
            finally {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            preparedStatement = connection.prepareStatement("DELETE FROM sqlj.jar_entry WHERE jarId = ?");
            try {
                preparedStatement.setInt(1, n);
                preparedStatement.executeUpdate();
            }
            finally {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            Commands.addClassImages(connection, n, string);
            if (bl) {
                Commands.deployInstall(connection, n);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJar(String string, boolean bl) throws SQLException {
        Commands.assertJarName(string);
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            int n = Commands.getJarId(connection, string);
            if (n < 0) {
                throw new SQLException("No Jar named '" + string + "' is known to the system");
            }
            if (bl) {
                Commands.deployRemove(connection, n);
            }
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM sqlj.jar_repository WHERE jarId = ?");
            try {
                preparedStatement.setInt(1, n);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new SQLException("Jar repository update did not update 1 row");
                }
            }
            finally {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassPath(String string, String string2) throws SQLException {
        block37: {
            Connection connection = DriverManager.getConnection("jdbc:default:connection");
            try {
                int n;
                PreparedStatement preparedStatement;
                string = string == null || string.length() == 0 ? "public" : string.toLowerCase();
                if (Commands.getSchemaId(connection, string) == null) {
                    throw new SQLException("No such schema: " + string);
                }
                ArrayList<Integer> arrayList = null;
                if (string2 != null && string2.length() > 0) {
                    arrayList = new ArrayList<Integer>();
                    preparedStatement = connection.prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName = ?");
                    try {
                        int n2;
                        do {
                            String string3;
                            if ((n2 = string2.indexOf(58)) >= 0) {
                                string3 = string2.substring(0, n2);
                                string2 = string2.substring(n2 + 1);
                            } else {
                                string3 = string2;
                            }
                            n = Commands.getJarId(preparedStatement, string3);
                            if (n < 0) {
                                throw new SQLException("No such jar: " + string3);
                            }
                            arrayList.add(new Integer(n));
                        } while (n2 >= 0);
                    }
                    finally {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                preparedStatement = connection.prepareStatement("DELETE FROM sqlj.classpath_entry WHERE schemaName = ?");
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                finally {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (arrayList == null) break block37;
                preparedStatement = connection.prepareStatement("INSERT INTO sqlj.classpath_entry(schemaName, ordinal, jarId) VALUES(?, ?, ?)");
                try {
                    int n3 = arrayList.size();
                    for (int i = 0; i < n3; ++i) {
                        n = (Integer)arrayList.get(i);
                        preparedStatement.setString(1, string);
                        preparedStatement.setInt(2, i + 1);
                        preparedStatement.setInt(3, n);
                        preparedStatement.executeUpdate();
                    }
                }
                finally {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String getClassPath(String var0) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void addClassImages(Connection connection, int n, String string) throws SQLException {
        InputStream inputStream = null;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        try {
            JarEntry jarEntry;
            int n2 = -1;
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            statement = connection.prepareStatement("INSERT INTO sqlj.jar_entry(entryName, jarId, entryImage) VALUES(?, ?, ?)");
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                int n3;
                if (jarEntry.isDirectory()) continue;
                String string2 = jarEntry.getName();
                Attributes attributes = jarEntry.getAttributes();
                boolean bl = false;
                if (attributes != null && (bl = "true".equalsIgnoreCase(attributes.getValue("SQLJDeploymentDescriptor"))) && n2 >= 0) {
                    throw new SQLException("Only one SQLJDeploymentDescriptor allowed");
                }
                byteArrayOutputStream.reset();
                while ((n3 = jarInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                }
                jarInputStream.closeEntry();
                statement.setString(1, string2);
                statement.setInt(2, n);
                statement.setBytes(3, byteArrayOutputStream.toByteArray());
                if (statement.executeUpdate() != 1) {
                    throw new SQLException("Jar entry insert did not insert 1 row");
                }
                if (!bl) continue;
                statement2 = connection.prepareStatement("SELECT entryId FROM sqlj.jar_entry WHERE jarId = ? AND entryName = ?");
                statement2.setInt(1, n);
                statement2.setString(2, string2);
                resultSet = statement2.executeQuery();
                if (!resultSet.next()) {
                    throw new SQLException("Failed to refecth row in sqlj.jar_entry");
                }
                n2 = resultSet.getInt(1);
            }
            if (n2 >= 0) {
                statement.close();
                statement = connection.prepareStatement("UPDATE sqlj.jar_repository SET deploymentDesc = ? WHERE jarId = ?");
                statement.setInt(1, n2);
                statement.setInt(2, n);
                if (statement.executeUpdate() != 1) {
                    throw new SQLException("Jar repository update did not insert 1 row");
                }
            }
        }
        catch (IOException iOException) {
            throw new SQLException("I/O exception reading jar file: " + iOException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement2 != null) {
                try {
                    statement2.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected static void deployInstall(Connection connection, int n) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor = Commands.getDeploymentDescriptor(connection, n);
        if (sQLDeploymentDescriptor != null) {
            sQLDeploymentDescriptor.install(connection);
        }
    }

    protected static void deployRemove(Connection connection, int n) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor = Commands.getDeploymentDescriptor(connection, n);
        if (sQLDeploymentDescriptor != null) {
            sQLDeploymentDescriptor.remove(connection);
        }
    }

    protected static void assertJarName(String string) throws SQLException {
        int n;
        if (string != null && (n = string.length()) > 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
            int n2;
            for (n2 = 1; n2 < n && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
            }
            if (n2 == n) {
                return;
            }
        }
        throw new SQLException("The jar name '" + string + "' is not a valid name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getJarId(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName = ?");
        try {
            int n = Commands.getJarId(preparedStatement, string);
            return n;
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getJarId(PreparedStatement preparedStatement, String string) throws SQLException {
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            if (!resultSet.next()) {
                int n = -1;
                return n;
            }
            int n = resultSet.getInt(1);
            return n;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * Exception decompiling
     */
    protected static SQLDeploymentDescriptor getDeploymentDescriptor(Connection var0, int var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 30[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static Oid getSchemaId(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block20: {
            preparedStatement = connection.prepareStatement("SELECT oid FROM pg_namespace WHERE nspname = ?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block20;
            Oid oid = null;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return oid;
        }
        Oid oid = (Oid)resultSet.getObject(1);
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return oid;
        {
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

