<?php // $Id: admin.php,v 1.4 2001/05/07 06:48:25 ciaccia Exp $ - #phpAdsNew Revision: 1.8 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by Matteo Beccati                                 */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/




// Include required files
require ("config.php");


// Security check
phpAds_checkAccess(phpAds_Admin);



/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

$extra = '';

if ($phpAds_compact_stats)
{
	// Determine left over verbose stats
	$viewresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adviews");
	$viewrow = @pg_fetch_array($viewresult, 0);
	$verboseviews = $viewrow["cnt"];
	
	$clickresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adclicks");
	$clickrow = @pg_fetch_array($viewresult, 0);
	$verboseclicks = $clickrow["cnt"];
	
	if ($verboseviews > 0 || $verboseclicks > 0)
	{
		// Show link to verbose stats convertor
		$extra = "<br><br>
				  <table cellspacing='1' cellpadding='0' width='140' bgcolor='#000088'><tr><td>
				  <table cellspacing='4' bgcolor='#FFFFFF'><tr>
				  <td valign='top'><img src='images/info.gif' vspace='absmiddle'></td>
				  <td valign='top'><b>Alert:</b><br>
				  You have enabled the compact statistics, but your old statistics are still 
				  in verbose format. Do you want to convert your verbose statistics to the 
				  new compact format?<br><br>
				  <a href='stats-convert.php?command=frame' target='_new' onClick=\"return openWindow('stats-convert.php?command=frame','','status=yes,scrollbars=yes,resizable=yes,width=400,height=500');\">
				  <img src='images/go_blue.gif' border='0'>&nbsp;Convert</a>
				  </td>
				  </tr></table>
				  </td></tr></table>";
	}
}

if (isset($message))
	phpAds_ShowMessage($message);

phpAds_PageHeader("$strAdminstration");

phpAds_ShowNav("1", $extra);


/*********************************************************/
/* Main code                                             */
/*********************************************************/

if (!isset($selection)) $selection = "all";

echo "<table border='0' width='100%' cellpadding='0' cellspacing='0'>";	
echo "<tr><td height='25' colspan='2'><b>$strClients</b></td></tr>";
echo "<tr height='1'><td colspan='2' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>";

echo "<form name='client_selection' action='admin.php'>";
echo "<tr><td height='35' colspan='2'>";
echo "<select name='selection' onChange='this.form.submit();'>";

echo "<option value='all' ".($selection=="all"?"selected":"").">$strShowAllClients</option>";
echo "<option value='active' ".($selection=="active"?"selected":"").">$strShowClientsActive</option>";
echo "<option value='nonactive' ".($selection=="nonactive"?"selected":"").">$strShowClientsInactive</option>";

echo "</select>";
echo "&nbsp;<a href='javascript:document.client_selection.submit();'><img src='images/go_blue.gif' border='0'></a>";
echo "</td></tr>";
echo "</form>";
echo "</table>";

echo "<br><br>";


switch($selection)
	{
	case "all":
		$res_clients = db_query("SELECT clientname, clientID FROM $phpAds_tbl_clients ORDER BY clientname") or pg_die();
		break;
	case "active":
		$res_clients = db_query("SELECT $phpAds_tbl_clients.clientname, $phpAds_tbl_clients.clientID FROM $phpAds_tbl_clients, $phpAds_tbl_banners WHERE $phpAds_tbl_clients.clientID=$phpAds_tbl_banners.clientID AND $phpAds_tbl_banners.active='t' GROUP BY $phpAds_tbl_clients.clientID, clientname ORDER BY clientname") or pg_die();
		break;
	case "nonactive":
		$res_clients = db_query("SELECT $phpAds_tbl_clients.clientname, $phpAds_tbl_clients.clientID FROM $phpAds_tbl_clients, $phpAds_tbl_banners WHERE $phpAds_tbl_clients.clientID=$phpAds_tbl_banners.clientID AND $phpAds_tbl_banners.active='f' GROUP BY $phpAds_tbl_clients.clientID, clientname ORDER BY clientname") or pg_die();
		break;
	}

// @my_sql_data_seek($res_clients, 0); // added _ between my and sql to exclude this line from grep

echo "<table border='0' width='100%' cellpadding='0' cellspacing='0'>";	
echo "<tr height='1'><td colspan='2' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>";

echo "<form name='client_delete' action='client-delete.php'>";

for ($i = 0; $row_clients = @pg_fetch_array($res_clients, $i); $i++)
{
	echo "<tr height='30' ".($i%2==0?"bgcolor='#F6F6F6'":"").">";
	echo "<td height='30'>&nbsp;<input type='checkbox' name='clientID[]' value='$row_clients[clientid]'>";
	echo "&nbsp;$row_clients[clientname]</td>";	
	echo "<td height='30' align='right'><a href='client-edit.php?clientID=$row_clients[clientid]'>[ $strModifyClient ]</a>&nbsp;&nbsp;";
	echo "<a href='banner-client.php?clientID=$row_clients[clientid]'>[ $strBannerAdmin ]</a>&nbsp;&nbsp;";
	echo "<a href='stats-client.php?clientID=$row_clients[clientid]'>[ $strStats ]</a>&nbsp;&nbsp;";
	echo "</td></tr>";
			
	echo "<tr height='1'><td colspan='2' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>";
}

echo "</form>";

echo "<tr height='25'><td height='25' colspan='2'>";
echo "<img src='images/go_blue.gif'>&nbsp;<a href=client-edit.php>$strAddClient</a>&nbsp;&nbsp;&nbsp;&nbsp;";
echo "<img src='images/go_blue.gif'>&nbsp;<a href=\"javascript:confirm_submit('client_delete', '$strConfirmDeleteClient');\">$strDeleteClient</a>&nbsp;&nbsp;&nbsp;&nbsp;";
echo "</td></tr>";
echo "</table>";

?>

<br><br><br><br>

<?
	// total number of clients
	$res_clients 		= db_query("SELECT count(*) as count FROM $phpAds_tbl_clients") or pg_die();
	$res_active_clients = db_query("SELECT count(*) as count FROM $phpAds_tbl_clients WHERE active='t'");
	$res_total_banners 	= db_query("SELECT count(*) as count FROM $phpAds_tbl_banners");
	$res_active_banners = db_query("SELECT count(*) as count FROM $phpAds_tbl_banners as b, $phpAds_tbl_clients as c WHERE b.clientID=c.clientID AND c.active='t' AND b.active='t'");
?>

<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
  <tr><td height='25' colspan='4'><b><?echo $strOverall;?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  <tr><td height='25'><?echo $strTotalClients;?>: <b><?echo @pg_result($res_clients, 0, "count");?></b></td>
      <td height='25'><?echo $strActiveClients;?>: <b><?echo @pg_result($res_active_clients, 0, "count");?></b></td>
      <td height='25'><?echo $strTotalBanners;?>: <b><?echo @pg_result($res_total_banners, 0, "count");?></b></td>
      <td height='25'><?echo $strActiveBanners;?>: <b><?echo @pg_result ($res_active_banners, 0, "count");?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>

</table>   

<br><br>


<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
  <tr><td height='25' colspan='4'><b><?echo $strStats;?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>

<?
	// stats today
	$adviews = db_total_views("", "day");
	$adclicks = db_total_clicks("", "day");
	if ($adviews > 0)
		$ctr = number_format($adclicks/$adviews*100,2);
	else
		$ctr="0.00";
?>

  <tr><td height='25'><?echo $strToday;?></td>
  	  <td height='25'><?echo $strViews;?>: <b><?echo $adviews;?></b></td>
      <td height='25'><?echo $strClicks;?>: <b><?echo $adclicks;?></b></td>
      <td height='25'><?echo $strCTRShort;?>: <b><?echo $ctr;?>%</b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break-el.gif' height='1' width='100%'></td></tr>

<?
	// stats this week
	$adviews = db_total_views("", "week");
	$adclicks = db_total_clicks("", "week");
	if ($adviews > 0)
		$ctr = number_format($adclicks/$adviews*100,2);
	else
		$ctr="0.00";
?>

  <tr><td height='25'><?echo $strThisWeek;?></td>
   	  <td height='25'><?echo $strViews;?>: <b><?echo $adviews;?></b></td>
      <td height='25'><?echo $strClicks;?>: <b><?echo $adclicks;?></b></td>
      <td height='25'><?echo $strCTRShort;?>: <b><?echo $ctr;?>%</b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break-el.gif' height='1' width='100%'></td></tr>

<?
	// stats this month
	$adviews = db_total_views("", "month");
	$adclicks = db_total_clicks("", "month");
	if ($adviews > 0)
		$ctr = number_format($adclicks/$adviews*100,2);
	else
		$ctr="0.00";
?>

  <tr><td height='25'><?echo $strThisMonth;?></td>
  	  <td height='25'><?echo $strViews;?>: <b><?echo $adviews;?></b></td>
      <td height='25'><?echo $strClicks;?>: <b><?echo $adclicks;?></b></td>
      <td height='25'><?echo $strCTRShort;?>: <b><?echo $ctr;?>%</b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break-el.gif' height='1' width='100%'></td></tr>
  
  
<?
	// overall stats
	$adviews = db_total_views();
	$adclicks = db_total_clicks();
	if ($adviews > 0)
		$ctr = number_format($adclicks/$adviews*100,2);
	else
		$ctr="0.00";
?>

  <tr><td height='25'><?echo $strOverall;?></td>
  	  <td height='25'><?echo $strViews;?>: <b><?echo $adviews;?></b></td>
      <td height='25'><?echo $strClicks;?>: <b><?echo $adclicks;?></b></td>
      <td height='25'><?echo $strCTRShort;?>: <b><?echo $ctr;?>%</b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  
  <tr height='25'>
	<td colspan='4' height='25'>
	<?
		if ($adclicks > 0 || $adviews > 0)
		{
			print "<img src='images/go_blue.gif'>&nbsp;<a href='stats-weekly.php?clientID=0'>$strWeeklyStats</a>&nbsp;&nbsp;&nbsp;&nbsp;";
		}
	?>
	</td>
  </tr>
</table>   

<br><br>



<?

/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

phpAds_PageFooter();

?>
