<?php

/**************************************************
Program name:	display_table.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Builds the Navigation Bar for 
		displays tables or sql results.  
		An example is:
		1 | 2 | 3 | 4 | 5 | Next > | End >> 

Create Date:	6/29/01 

Modified Date(s):
	
**************************************************/


	//Build Navigation
	# set position
	if (!isset($pos)) { 
		$pos = 0 ;
	}
	
	# get next and previous positions
	$pos_next = $pos + $cfgMaxRows;
	$pos_prev = $pos - $cfgMaxRows;
	
	# if number of rows is less than the number allow to be displayed then pos_next simply
	# equals the number of rows
	if ($num_rows < $pos_next) {
		$pos_next = $num_rows;
	}

#	echo "nsql:".$nsql_query;
#	echo "sql:".$sql_query;


	if ($pos >= $cfgMaxRows) {
		//doj added link to beginning of results
		$strNavigation .= "<a class=link href=sqlresults.php?sql_query=".urlencode($nsql_query)."&sql_order=".urlencode($sql_order)."&pos=0".">".$strPos1."</a>"." | ";

		$strNavigation .= "<a class=link href=sqlresults.php?sql_query=".urlencode($nsql_query)."&sql_order=".urlencode($sql_order)."&pos=".$pos_prev.">".$strPrevious."</a>"." | ";
	} else {
		$strNavigation .= "";
	}

	//doj now only the previous and next $cfgMaxPages pages will be shown
	if (empty($cfgMaxPages)) {
		$cfgMaxPages = 9;
	}

	$iCount = $pos - ($cfgMaxRows * $cfgMaxPages);
	
	if ($iCount < 0) {
		$iCount = 0;
	}

	$iPageCnt = (int)($iCount / $cfgMaxRows); 
	$iPageStop = $pos + ($cfgMaxRows * ($cfgMaxPages + 1));

	for (; $iCount < $num_rows && $iCount < $iPageStop; $iCount += $cfgMaxRows) {
	  //doj until here
		$iPageCnt++;
		if ($iCount != $pos) {
			$strPages .= "<a class=link href=sqlresults.php?sql_query=".urlencode($nsql_query)."&sql_order=".urlencode($sql_order)."&pos=".$iCount.">".$iPageCnt."</a>"." | ";
		} else {
			if ($num_rows > $cfgMaxRows) {
				$strPages .= "$iPageCnt | ";
			}
		}
	}

	$strNavigation .= ereg_replace(" \| $", "", $strPages);
	
	if ($pos_next < $num_rows) {
		$strNavigation .= " | <a class=link href=sqlresults.php?sql_query=".urlencode($nsql_query)."&sql_order=".urlencode($sql_order)."&pos=".$pos_next.">".$strNext."</a>";

		//doj link to end of results
		$pos_end = $num_rows - $cfgMaxRows;
		$strNavigation .= " | <a class=link href=sqlresults.php?sql_query=".urlencode($nsql_query)."&sql_order=".urlencode($sql_order)."&pos=".$pos_end.">".$strEnd."</a>";
	} else {
		$strNavigation .= "";
	}

?>



