/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: mmsystem.c */
#include "mmsystem.h"
#include "common.h"

struct mem_list* mlist = NULL;				/* ALWAYS INITIALIZE WITH NULL, OR WILL BE TROUBLE !!!! */

void add_to_special_memlist(struct mem_list** head, void* ptr)
{
 struct mem_list* newh;
/* debug("%s:%d",__FILE__,__LINE__);*/
 if (!(*head))
   {
    *head = (struct mem_list*)malloc(sizeof(struct mem_list));
    if (!(*head)) { fatal("malloc mlist failed!"); return; }
    (*head)->ptr  = ptr;
    (*head)->next = NULL;
    return;
   }
 newh = (struct mem_list*)malloc(sizeof(struct mem_list));
 if (!newh) { fatal("malloc mlist failed!"); return; }
 newh->ptr   = ptr;
 newh->next  = *head;
 *head       = newh; 
}


void print_special_memlist(struct mem_list* head)
{
 struct mem_list* tmp;
 debug("%s:%d",__FILE__,__LINE__);
 tmp = head;
 printf("MEMLIST_SPECIAL:\n");
 while (tmp)
   {
    printf("%p\n", tmp->ptr);
    tmp = tmp->next;
   }
 printf("MEMLIST_SPECIAL END\n");
}

void del_from_special_memlist(struct mem_list** head, void* ptr)
{
 struct mem_list *tmp, *prev;
/* debug("%s:%d",__FILE__,__LINE__);*/
 tmp = prev = *head;
 while (tmp)
   {
    if (tmp->ptr==ptr)
      {
       if (tmp==(*head))
         {
          *head = tmp->next;
	  free(tmp);
	  tmp = NULL;
	  return ;
         }
       prev->next = tmp->next;
       free(tmp);
       tmp = NULL;
       return ;
      }
    prev = tmp;
    tmp = tmp->next;
   }
 fatal("SPECIAL_MEMLIST: No such pointer: %p", ptr);
}

void add_to_memlist(void* ptr)
{
 struct mem_list* newh;
/* debug("%s:%d",__FILE__,__LINE__);*/
 if (!mlist)
   {
    mlist = (struct mem_list*)malloc(sizeof(struct mem_list));
    if (!mlist) { fatal("malloc mlist failed!"); return; }
    mlist->ptr  = ptr;
    mlist->next = NULL;
    return;
   }
 newh = (struct mem_list*)malloc(sizeof(struct mem_list));
 if (!newh) { fatal("malloc mlist failed!"); return; }
 newh->ptr   = ptr;
 newh->next  = mlist;
 mlist       = newh; 
}


void print_memlist()
{
 struct mem_list* tmp;
 debug("%s:%d",__FILE__,__LINE__);
 tmp = mlist;
 printf("MEMLIST:\n");
 while (tmp)
   {
    printf("%p\n", tmp->ptr);
    tmp = tmp->next;
   }
 printf("MEMLIST END\n");
}

void del_from_memlist(void* ptr)
{
 struct mem_list *tmp, *prev;
/* debug("%s:%d",__FILE__,__LINE__);*/
 tmp = prev = mlist;
 while (tmp)
   {
    if (tmp->ptr==ptr)
      {
       if (tmp==mlist)
         {
          mlist = tmp->next;
	  free(tmp);
	  tmp = NULL;
	  return ;
         }
       prev->next = tmp->next;
       free(tmp);
       tmp = NULL;
       return ;
      }
    prev = tmp;
    tmp = tmp->next;
   }
 fatal("MEMLIST: No such pointer: %p", ptr);
}

void shred_memlist()
{
 struct mem_list *tmp, *prev;
 debug("%s:%d",__FILE__,__LINE__);
 tmp = prev = mlist;
 while (tmp)
   {
    prev = tmp;
    free(prev);
    prev = NULL;
    tmp = tmp->next;
   }
 mlist = NULL;
}

void shred_special_memlist(struct mem_list** head)
{
 struct mem_list *tmp, *prev;
 debug("%s:%d",__FILE__,__LINE__);
 tmp = prev = *head;
 while (tmp)
   {
    prev = tmp;
    free(prev);
    prev = NULL;
    tmp = tmp->next;
   }
 *head = NULL;
}

void* mmalloc(int siz)
{
 void* ptr;
/* debug("%s:%d",__FILE__,__LINE__);*/
 if (siz<=0) return NULL;
 ptr = malloc(siz);
 if (!ptr) { gtk_dialog_printf("mmalloc failed!"); exit(0); return NULL; }
 add_to_memlist(ptr);
 return ptr;
}

void mfree(void** ptr)
{
/* debug("%s:%d",__FILE__,__LINE__);*/
 del_from_memlist(*ptr);
 if (*ptr) free(*ptr);
 *ptr = NULL;
}

void* smalloc(struct mem_list** headp, int siz)
{
 void* ptr;
/* debug("%s:%d",__FILE__,__LINE__);*/
 if (siz<=0) return NULL;
 ptr = malloc(siz);
 if (!ptr) { gtk_dialog_printf("smalloc failed!"); exit(0); return NULL; }
 add_to_special_memlist(headp, ptr);
 return ptr;
}

void sfree(struct mem_list** headp, void** ptr)
{
/* debug("%s:%d",__FILE__,__LINE__);*/
 del_from_special_memlist(headp, *ptr);
 if (*ptr) free(*ptr);
 *ptr = NULL;
}

