/*
 * Table.java
 *
 * Created on 31 de julio de 2002, 09:58
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  nestor
 */
public class Table extends DBObject {
    private long pages_number = 0;
    private Vector columns = null;
    private Vector index = null;
    private Vector foreign_keys = null;
    private String description = null;

    /** Creates a new instance of Table */
    public Table(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    public Table(DBObject owner) {
        super(owner);
    }

    public boolean Drop(){
        boolean retorno = false;
        try{
            retorno = getConnection().executeUpdate("DROP TABLE " + getName()) > 0;
        } catch (SQLException e){
            JOptionPane.showMessageDialog(null, e.getMessage(), "Can't drop object", JOptionPane.ERROR_MESSAGE);
        }
        return retorno;
    }

    public void insertRecord(Vector values) throws SQLException {
        PreparedStatement prep = prepareInsertStatement();
        for(int i=0; i< getColumns().size(); i++){
            setStatementValue(prep, (String) values.get(i),  (TableColumn) getColumns().get(i), i+1);
        }
        prep.executeUpdate();
        prep.close();
    }
    public void updateRecord(Vector values) throws SQLException {
        PreparedStatement prep = prepareUpdateStatement();

        int values_idx = 0;
        for(int i=0; i< getColumns().size(); i++){
            setStatementValue(prep, (String) values.get(values_idx),  (TableColumn) getColumns().get(i), values_idx+1);
            values_idx++;
        }
        Vector cols = ((TableIndex) getPrimaryKeys().get(0)).getColumns();
        for (int i=0; i< cols.size(); i++) {
            setStatementValue(prep, (String) values.get(values_idx),  (TableColumn) cols.get(i), values_idx+1);
            values_idx++;
        }

        prep.executeUpdate();
        prep.close();
    }
    public void deleteRecord(Vector values) throws SQLException {
        PreparedStatement prep = prepareDeleteStatement();
        Vector cols = ((TableIndex) getPrimaryKeys().get(0)).getColumns();
        for (int i=0; i< cols.size(); i++) {
            setStatementValue(prep, (String) values.get(i),  (TableColumn) cols.get(i), i+1);
        }
        prep.executeUpdate();
        prep.close();
    }

    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP TABLE ");
        retorno.append(getName());
        retorno.append("; \n\t");
        return retorno.toString();
    }

    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE TABLE ");
        retorno.append(getName());
        retorno.append(" ( ");
        for(int i=0; i<getColumns().size(); i++){
            if(i>0){
                retorno.append(", \n\t");
            }
            TableColumn tc = (TableColumn) getColumns().get(i);
            retorno.append(tc.getInsertSQL());
        }

        Vector tmp = getPrimaryKeys();
        for(int i=0; i<tmp.size(); i++){
            retorno.append(", \n\t");
            retorno.append(((TableIndex) tmp.get(i)).getInsertSQL());
        }

        tmp = getForeignKeys();
        for(int i=0; i<tmp.size(); i++){
            retorno.append(", \n\t");
            retorno.append(((TableForeignKey) tmp.get(i)).getInsertSQL());
        }

        retorno.append(" \n);\n");

        tmp = getNotPrimaryKeyIndex();
        for(int i=0; i<tmp.size(); i++){
            retorno.append(((TableIndex) tmp.get(i)).getInsertSQL());
            retorno.append("\n");
        }

        retorno.append(getCommentSQL());
        for(int i=0; i<getColumns().size(); i++){
            TableColumn tc = (TableColumn) getColumns().get(i);
            retorno.append(tc.getCommentSQL());
            retorno.append("\n");
        }

        return retorno.toString();
    }

    /** Find the object asociated with the Name.
     * @param _name Name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();

            ResultSet rs = getConnection().getQueryGenerator().getTable(_name);
            if((rs != null) && rs.next()){
                setName(rs.getString("table_name"));
                setNumberOfPages(rs.getLong("table_pages"));
                setCreator(new User(this, rs.getString("table_owner")));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }

    public void initialize(){
        super.initialize();
        pages_number = 0;
        columns = null;
        foreign_keys = null;
        index = null;
        description = null;
    }


    // -------SET AND GET ----------
    public long getNumberOfPages(){
        return pages_number;
    }

    public Vector getColumns(){
        if(columns == null){
            columns = new Vector();

            try{
                ResultSet rs = getConnection().getQueryGenerator().getColumnNames(getName());
                while((rs != null) && rs.next()){
                    TableColumn tc = new TableColumn(this, rs.getString("column_name"));
                    columns.add(tc);
                }
                rs.close();
                rs.getStatement().close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return columns;
    }
    public int getColumnIndex(String _column){
        _column = _column.toUpperCase();
        int retorno = -1;
        Vector cols = getColumns();
        for(int i =0 ; (i<cols.size()) && (retorno < 0) ; i++){
            if (((TableColumn) cols.get(i)).getName().equals(_column)){
                retorno = i;
            }
        }
        return retorno;
    }

    public Vector getIndexes(){
        if(index == null){
            index = new Vector();
            try{
                ResultSet rs = getConnection().getQueryGenerator().getIndexNames(getName());
                while((rs != null) && rs.next()){
                    TableIndex ti = new TableIndex(this, rs.getString("index_name"));
                    index.add(ti);
                }
                rs.close();
                rs.getStatement().close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return index;
    }
    public Vector getPrimaryKeys(){
        Vector retorno = new Vector();
        Vector tmp = getIndexes();
        for(int i=0;i < tmp.size(); i++){
            if(((TableIndex) tmp.get(i)).isPrimary()){
                retorno.add(tmp.get(i));
            }
        }
        return retorno;
    }
    public Vector getNotPrimaryKeyIndex(){
        Vector retorno = new Vector();
        Vector tmp = getIndexes();
        for(int i=0;i < tmp.size(); i++){
            if(!((TableIndex) tmp.get(i)).isPrimary()){
                retorno.add(tmp.get(i));
            }
        }
        return retorno;
    }

    public Vector getForeignKeys(){
        if(foreign_keys == null){
            foreign_keys = new Vector();

            try{
                ResultSet rs = getConnection().getQueryGenerator().getTableForeignKeyNames(getName());
                while((rs != null) && rs.next()){
                    TableForeignKey tc = new TableForeignKey(this, rs.getString("fk_name"));
                    foreign_keys.add(tc);
                }
                rs.close();
                rs.getStatement().close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return foreign_keys;
    }

    public String getDescription()
    {
      if(description == null)
      {
        description = getConnection().getQueryGenerator().getTableDescription(getName());
      }
      return description;
    }

    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }

// -------- PRIVATE MEHTODS     -------------
    private PreparedStatement prepareInsertStatement() throws SQLException{
        StringBuffer sqlComm = new StringBuffer();
        sqlComm.append("INSERT INTO ");
        sqlComm.append(getName());
        sqlComm.append(" ( ");
        for(int i=0; i<getColumns().size(); i++){
            TableColumn tc = (TableColumn) getColumns().get(i);
            sqlComm.append(tc.getName());
            if( i<getColumns().size()-1){
                sqlComm.append(", ");
            }
        }
        sqlComm.append(" ) VALUES ( ");
        for(int i=0; i<getColumns().size(); i++){
            sqlComm.append(" ?");
            if( i<getColumns().size()-1){
                sqlComm.append(", ");
            }
        }
        sqlComm.append(" )");
        return getConnection().prepareStatement(sqlComm.toString());
    }

    private PreparedStatement prepareUpdateStatement() throws SQLException{
        StringBuffer sqlComm = new StringBuffer();
        sqlComm.append("UPDATE ");
        sqlComm.append(getName());
        sqlComm.append(" SET ");
        for(int i=0; i<getColumns().size(); i++){
            TableColumn tc = (TableColumn) getColumns().get(i);
            sqlComm.append(tc.getName());
            sqlComm.append("= ? ");
            if( i<getColumns().size()-1){
                sqlComm.append(", ");
            }
        }
        sqlComm.append(" WHERE ");
        Vector cols = ((TableIndex) getPrimaryKeys().get(0)).getColumns();
        for(int i=0; i<cols.size(); i++){
            TableColumn tc = (TableColumn) cols.get(i);
            sqlComm.append(tc.getName());
            sqlComm.append("=? ");
            if(i < cols.size()-1){
                sqlComm.append(" and ");
            }
        }
        return getConnection().prepareStatement(sqlComm.toString());
    }

    private PreparedStatement prepareDeleteStatement() throws SQLException{
        StringBuffer sqlComm = new StringBuffer();
        sqlComm.append("DELETE FROM ");
        sqlComm.append(getName());
        sqlComm.append(" WHERE ");
        Vector cols = ((TableIndex) getPrimaryKeys().get(0)).getColumns();
        for(int i=0; i<cols.size(); i++){
            TableColumn tc = (TableColumn) cols.get(i);
            sqlComm.append(tc.getName());
            sqlComm.append("=? ");
            if(i < cols.size()-1){
                sqlComm.append(" and ");
            }
        }
        return getConnection().prepareStatement(sqlComm.toString());
    }

    private void setStatementValue(PreparedStatement prep, String value, TableColumn tc, int _prepcolumn){
        int type = (int) tc.getColumnType().getSQLType();
        if(type < 0){
            type = Types.CHAR;
        }

        try{
            if ((value != null) && (value.length() > 0)){
                switch (type){
                    case Types.BIT:
                        prep.setBoolean(_prepcolumn, Utilities.parseBoolean(value));
                        break;
                    case Types.CHAR:
                        prep.setString(_prepcolumn, value);
                        break;
                    case Types.INTEGER:
                        prep.setInt(_prepcolumn, Integer.parseInt(value));
                        break;
                    case Types.DATE:
                        prep.setDate(_prepcolumn, new java.sql.Date(Utilities.parseDate(value, Utilities.FORMAT_DATE).getTime()));
                        break;
                    case Types.TIME:
                        prep.setTime(_prepcolumn, new java.sql.Time(Utilities.parseDate(value, Utilities.FORMAT_TIME).getTime()));
                        break;
                    case Types.TIMESTAMP:
                        prep.setTimestamp(_prepcolumn, new java.sql.Timestamp(Utilities.parseDate(value, Utilities.FORMAT_DATETIME).getTime()));
                        break;
                    case Types.DOUBLE:
                        prep.setDouble(_prepcolumn, Double.parseDouble(value));
                        break;
                }
            } else {
                prep.setNull(_prepcolumn, type);
            }
        } catch (Exception e){
            e.printStackTrace();
        }
    }

    private String getCommentSQL()
    {
      String retorno = new String();
      String description = getDescription();

      if(description != null && description.length() > 0)
      {
        retorno = "COMMENT ON TABLE " + getName()
                + " IS '" + getDescription() + "'; \n";
      }
      return retorno;
    }

    private void setNumberOfPages(long _pages_number){
        pages_number = _pages_number;
    }

    private void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
}
