/*
 * Decompiled with CFR 0.152.
 */
package components.sequence;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pgclibrary.objects.Sequence;
import pgclibrary.utilities.SUtilities;

public class SequencePanel
extends JTabbedPane {
    Sequence sequence_object = null;
    JTextField name = new JTextField(20);
    JTextField creator = new JTextField(20);
    JTextArea description = new JTextArea(3, 20);
    JTextField increment = new JTextField(20);
    JTextField last = new JTextField(20);
    JTextField max = new JTextField(20);
    JTextField min = new JTextField(20);
    JTextArea sql = new JTextArea();

    public SequencePanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setSequence(Sequence sequence) {
        this.sequence_object = sequence;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
    }

    public void refreshProperties() {
        this.refreshDefaultPanel();
    }

    private void insertDefaultTab() {
        this.name.setEditable(false);
        this.creator.setEditable(false);
        this.increment.setEditable(false);
        this.last.setEditable(false);
        this.max.setEditable(false);
        this.min.setEditable(false);
        this.description.setEditable(false);
        this.description.setBorder(this.name.getBorder());
        this.description.setBackground(this.name.getBackground());
        this.description.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.description);
        jScrollPane.setPreferredSize(this.description.getPreferredSize());
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this.sql.setEditable(false);
        jSplitPane.setBottomComponent(new JScrollPane(this.sql));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(SUtilities.getHorPanel("Sequence Name :", this.name));
        jPanel.add(SUtilities.getHorPanel("Creator :", this.creator));
        jPanel.add(SUtilities.getHorPanel("Description :", jScrollPane));
        jPanel.add(SUtilities.getHorPanel("Increment by :", this.increment));
        jPanel.add(SUtilities.getHorPanel("Last Value :", this.last));
        jPanel.add(SUtilities.getHorPanel("Maximum Value :", this.max));
        jPanel.add(SUtilities.getHorPanel("Minimum Value :", this.min));
        jSplitPane.setTopComponent(SUtilities.centerComponent(jPanel));
        this.addTab("General", jSplitPane);
    }

    private void refreshDefaultPanel() {
        this.name.setText(this.sequence_object.getName());
        this.sql.setText(this.sequence_object.getInsertSQL());
        this.creator.setText(this.sequence_object.getCreator().getName());
        this.description.setText(this.sequence_object.getDescription());
        this.increment.setText(String.valueOf(this.sequence_object.getIncrementBy()));
        this.last.setText(String.valueOf(this.sequence_object.getLastValue()));
        this.max.setText(String.valueOf(this.sequence_object.getMaxValue()));
        this.min.setText(String.valueOf(this.sequence_object.getMinValue()));
        this.repaint();
    }
}

