/*
 * Dabatase.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package pgclibrary.treeObjects;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.util.*;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public class RootElement extends TreeInfo {
    private Database database = null;
    
    /** Creates a new instance of Dabatase */
    public RootElement(Database _database) {
        super(null);
        setDatabase(_database);
        setIcon("/images/objects.gif");
    }

    public Database getDatabase(){
        return database;
    }
    public void setDatabase(Database _database){
        database = _database;
    }
    
    public Object getOID() {
        return "root";
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        if(getDatabase().validate()){
            addProperty(new TableList(this));
            addProperty(new ViewList(this));
            addProperty(new SequenceList(this));
            addProperty(new UserList(this));
            addProperty(new GroupList(this));
            addProperty(new DatabaseList(this));
        }
    }
    
    public String toString(){
        String retorno = "Not connected" ;
        if(getConnection() != null){
            retorno = getConnection().getUserName()  + "@"+ getConnection().getDatabaseName();
        }
        return retorno;
    }
}
