/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.table.ColumnPanel;
import components.table.DataPanel;
import components.table.IndexPanel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pgclibrary.objects.Table;
import pgclibrary.utilities.SUtilities;

public class TablePanel
extends JTabbedPane {
    Table table_object = null;
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextField pages = new JTextField(20);
    JTextArea description = new JTextArea(3, 20);
    DataPanel data_panel = new DataPanel();
    ColumnPanel column_panel = new ColumnPanel();
    IndexPanel index_panel = new IndexPanel();
    JTextArea sql = new JTextArea();

    public TablePanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setTable(Table _table_object) {
        this.table_object = _table_object;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
        this.addTab("Columns", this.column_panel);
        this.addTab("Data", this.data_panel);
        this.addTab("Indexes", this.index_panel);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TablePanel.this.refreshProperties();
            }
        });
    }

    public void refreshProperties() {
        switch (this.getSelectedIndex()) {
            case 0: {
                this.refreshDefaultPanel();
                break;
            }
            case 1: {
                this.column_panel.refresh(this.table_object);
                break;
            }
            case 2: {
                this.data_panel.refresh(this.table_object);
                break;
            }
            case 3: {
                this.index_panel.refresh(this.table_object);
            }
        }
    }

    private void insertDefaultTab() {
        this.name.setEditable(false);
        this.owner.setEditable(false);
        this.pages.setEditable(false);
        this.description.setEditable(false);
        this.description.setBorder(this.pages.getBorder());
        this.description.setBackground(this.pages.getBackground());
        this.description.setLineWrap(true);
        JScrollPane dpane = new JScrollPane(this.description);
        dpane.setPreferredSize(this.description.getPreferredSize());
        JSplitPane panel = new JSplitPane(0);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        this.sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(this.sql));
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, 1));
        general_panel.add(SUtilities.getHorPanel("Table Name :", this.name));
        general_panel.add(SUtilities.getHorPanel("Description :", dpane));
        general_panel.add(SUtilities.getHorPanel("Table Owner :", this.owner));
        general_panel.add(SUtilities.getHorPanel("Disk Pages Used :", this.pages));
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        this.addTab("General", panel);
    }

    private void refreshDefaultPanel() {
        this.name.setText(this.table_object.getName());
        this.owner.setText(this.table_object.getCreator().getName());
        this.pages.setText(String.valueOf(this.table_object.getNumberOfPages()));
        this.sql.setText(this.table_object.getInsertSQL());
        this.description.setText(this.table_object.getDescription());
        this.repaint();
    }
}

