namespace eval ::files {
	namespace export *

	variable mCurrentFilename	
	
	proc Grep {pPattern {pFileList ""}} {
		set lResult ""
		
		if {([llength $pFileList] == 0)} {
			set lLineNumber 0
			while {([gets stdin lLine] >= 0)} {
				incr lLineNumber
				if {([regexp $pPattern $lLine] != 0)} {
					lappend lResult "$lLineNumber:$lLine"
				}
			}
		} else {
			foreach lFileName $pFileList {
				set lFile [open $lFileName r]
				set lLineNumber 0
				while {([gets $lFile lLine] >= 0)} {
					incr lLineNumber
					if {[regexp $pPattern $lLine]} {
						lappend lResult "$lFileName:$lLineNumber:$lLine"
					}
				}
				close $lFile
			}
		}
		return $lResult
	}

	proc Move {args} {
		set lProcName [lindex [info level 0] 0]
	
		set lOptions {
			{force				 {force the file to be moved}}
		}
		
		if {([catch {set lResult \
		[::commandline::GetOptions args $lOptions]} lCatch])} {
			return -code error -errorcode \
			[list EXCEPTION $lProcName $lCatch] $lCatch
		}
		
		array set lArguments $lResult
		
		set lForce ""
		if {($lArguments(force) == 1)} {
			set lForce "-force"
		}
		
		if {([llength $lArguments(argv)] != 2)} {
			set lMessage "wrong # args: should be \"$lProcName -force source dest\""
			return -code error -errorcode \
			[list EXCEPTION $lProcName $lMessage] $lMessage
		}
		
		if {([catch {file copy $lForce [lindex $lArguments(argv) 0] \
		[lindex $lArguments(argv) 1]} lCatch] != 0)} {
			return -code error -errorcode \
			[list EXCEPTION $lProcName $lCatch] $lCatch
		}
		
		if {([catch {file delete $lForce [lindex $lArguments(argv) 0]} \
		lCatch] != 0)} {
			return -code error -errorcode \
			[list EXCEPTION $lProcName $lCatch] $lCatch
		}
		return ""
	}

	proc Find {{pDirectory "."} {pFilterCommand ""}} {
		set lOldDirectory [pwd]
		if {([catch {cd $pDirectory}] !=0)} {
			return ""
		}
		
		set lCurrentDirectory [pwd]
		set lFileList [lsort -dictionary [glob -nocomplain * .*]]
		set lNewFileList ""
		set lFilterCommandLength [string length $pFilterCommand]
		foreach lSpecialFileName [list "." ".."] {
			set lIndex [lsearch -exact $lFileList $lSpecialFileName]
			set lFileList [lreplace $lFileList $lIndex $lIndex]
		}
		foreach lFileName $lFileList {
			if {($lFilterCommandLength == 0) || \
				([uplevel $pFilterCommand [list $lFileName]] != 0)} {
				lappend lNewFileList [file join $lCurrentDirectory $lFileName]
			}
			if {([file isdirectory $lFileName])} {
				set lNewFileList \
					[concat $lNewFileList [Find $lFileName $pFilterCommand]]
			}
		}
		cd $lOldDirectory
		return $lNewFileList
	}

	proc Cat {pFilename} {
	    set lFile [open $pFilename r]
	    set lData [read $lFile [file size $pFilename]]
	    close $lFile
	    return $lData
	}

	proc ImportDelimitedFile {pFileName {pDelimiter "\t"}} {
		set lFile [open $pFileName r]
		set lData ""
		while {([gets $lFile lLine] >= 0)} {
			set lList [split $lLine $pDelimiter]
			lappend lData $lList
		}
		close $lFile
		return $lData
	}
	
	proc ImportINIFile {pFileName} {
		set lFile [open $pFileName r]
		set lData ""
		set lResult(COUNT) 0
		while {([gets $lFile lLine] >= 0)} {
			if {([regexp -nocase "^\\\[(\[a-z]\[a-z0-9_ :.]*)]" \
			$lLine ignore lBlockName])} {
				if {(![info exists lResult($lBlockName,COUNT)])} {
					lappend lResult(BLOCKS) $lBlockName
					incr lResult(COUNT)
					set lResult($lBlockName,COUNT) 0
					set lResult($lBlockName,PARAMETERS) ""
				}
			} elseif {([regexp -nocase \
			"^(\[a-z_]\[a-z0-9_\,\-.]*)\[ \t]*=\[ \t]*\"*(\[^\"]*)" \
			$lLine ignore lParameterName lParameterValue])} {			
				if {([info exists lBlockName])} {
					if {($lBlockName != "")} {
						if {(![info exists \
						lResult($lBlockName,$lParameterName)])} {
							lappend lResult($lBlockName,PARAMETERS) \
								$lParameterName
							set lResult($lBlockName,$lParameterName) \
								$lParameterValue
							incr lResult($lBlockName,COUNT)
						}
					}
				}
			}
		}
		
		return [array get lResult]
	}

	proc ImportMailRC {} {
		set mailrc_file [open "~/.mailrc" r] 
	
		while {(![eof $mailrc_file])} {
			gets $mailrc_file buffer
			if {([info exists alias_name])} {unset alias_name}
			if {([regexp "alias (.*) (.*)\\\\" $buffer ignore \
			alias_name email_names])} {
				set mail_alias_array($alias_name) $email_names
				set p_result FOUND
				while {(![eof $mailrc_file])} {
					gets $mailrc_file buffer
					if {([regexp "(.*)\\\\" $buffer ignore email_names])} {
						set mail_alias_array($alias_name) \
							"$mail_alias_array($alias_name)$email_names"
					} else {
						set mail_alias_array($alias_name) \
							"$mail_alias_array($alias_name)$buffer"
						break
					}
				}
			}
			if {([info exists alias_name])} {
				set email_temp_list ""
				for {set x 0} \
				{$x < [llength $mail_alias_array($alias_name)]} {incr x 1} {
					if ([info exists \
					mail_alias_array([lindex \
					$mail_alias_array($alias_name) $x])]) {
						set email_temp_list [string trim \
							"$email_temp_list $mail_alias_array([lindex $mail_alias_array($alias_name) $x])"]
					} else {
						set email_temp_list [string trim \
							"$email_temp_list [lindex $mail_alias_array($alias_name) $x]"]
					}
				}
			
				set mail_alias_array($alias_name) $email_temp_list
			
				set email_temp_list ""
				for {set x 0} \
				{$x < [llength $mail_alias_array($alias_name)]} {incr x 1} {
					if {([lsearch $email_temp_list \
					[lindex $mail_alias_array($alias_name) $x]] == -1)} {
						lappend email_temp_list \
							[lindex $mail_alias_array($alias_name) $x]
					}
				}
				set mail_alias_array($alias_name) $email_temp_list
			}
		}
		return [array get mail_alias_array]
	}
}
