/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/server/ReplicationRunnable.java,v $
 * $Author: asullivan $ $Revision: 1.1.1.1 $ $Date: 2003/08/26 19:02:21 $
 *
 */

package com.postgres.replic.server;

import com.postgres.replic.server.props.*;
import com.postgres.replic.util.*;
import com.postgres.replic.util.struct.*;
import com.postgres.util.config.*;
import com.postgres.util.jdbc.*;
import com.postgres.util.timer.*;
import java.sql.*;

public class ReplicationRunnable extends AbstractReplicationRunnable
implements Runnable {

    public ReplicationRunnable(ServerProps serverProps,
    ConnectionPoolProps connPoolProps,
    ConnectionPool masterPool,
    ConnectionPool slavePool) throws ReplicationException {
        super(serverProps, connPoolProps, masterPool, slavePool);
    }


    public void run()  {
        try {
            getLogger().debug("ReplicationRunnable::run: BEGIN");
            getLogger().debug("ReplicationRunnable::run: BEGIN: sleep interval:" + getServerProps().getReplicIntervals()[getServerId()]);
            getLogger().debug("ReplicationRunnable::run: BEGIN: sleep interval: getSignal()" + getSignal());
            while (true && !(getSignal() == STOP)) {
                getRserv().replicate();
                getLogger().debug("ReplicationRunnable::run: BEGIN: inside the while loop");

                Thread.sleep(getServerProps().getReplicIntervals()
                    [getServerId()]);
            }
        } catch (InterruptedException ie) {
            getLogger().error("ReplicationRunnable::run: InterruptedException: calling destroy");
            destroy();
        } catch (Exception e) {
            String slaveURL= null;
            try {
                slaveURL = getSlaveURL();
            } catch (Exception ex) {
                getLogger().error("ReplicationRunnable::run: cannot get slaveURL ", ex);
            }
            getLogger().error("ReplicationRunnable::run: STOPPING THREAD URL: " + slaveURL + " BECAUSE OF ERROR:" + e.toString());
        } finally {

        }
    }
}
