/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class PriorityMatchFilter
extends Filter {
    public static final String PRIORITY_TO_MATCH_OPTION = "PriorityToMatch";
    public static final String ACCEPT_ON_MATCH_OPTION = "AcceptOnMatch";
    boolean acceptOnMatch = true;
    Priority priorityToMatch;

    public String[] getOptionStrings() {
        return new String[]{PRIORITY_TO_MATCH_OPTION, ACCEPT_ON_MATCH_OPTION};
    }

    public void setOption(String key, String value) {
        if (key.equalsIgnoreCase(PRIORITY_TO_MATCH_OPTION)) {
            this.priorityToMatch = Priority.toPriority(value, null);
        } else if (key.equalsIgnoreCase(ACCEPT_ON_MATCH_OPTION)) {
            this.acceptOnMatch = OptionConverter.toBoolean(value, this.acceptOnMatch);
        }
    }

    public void setPriorityToMatch(String priority) {
        this.priorityToMatch = Priority.toPriority(priority, null);
    }

    public String getPriorityToMatch() {
        return this.priorityToMatch == null ? null : this.priorityToMatch.toString();
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public boolean getAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public int decide(LoggingEvent event) {
        if (this.priorityToMatch == null) {
            return 0;
        }
        boolean matchOccured = false;
        if (this.priorityToMatch == event.priority) {
            matchOccured = true;
        }
        if (this.acceptOnMatch ^ matchOccured) {
            return -1;
        }
        return 1;
    }
}

