/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyWatchdog;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.CategoryFactory;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.OptionHandler;

public class PropertyConfigurator
extends BasicConfigurator
implements Configurator {
    protected Hashtable registry = new Hashtable(11);
    protected CategoryFactory categoryFactory = new DefaultCategoryFactory();
    static final String CATEGORY_PREFIX = "log4j.category.";
    static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    static final String ROOT_CATEGORY_PREFIX = "log4j.rootCategory";
    static final String APPENDER_PREFIX = "log4j.appender.";
    static final String RENDERER_PREFIX = "log4j.renderer.";
    static final String CATEGORY_FACTORY_KEY = "log4j.categoryFactory";
    private static final String INTERNAL_ROOT_NAME = "root";
    static /* synthetic */ Class class$org$apache$log4j$spi$CategoryFactory;
    static /* synthetic */ Class class$org$apache$log4j$Appender;
    static /* synthetic */ Class class$org$apache$log4j$Layout;

    public void doConfigure(String configFileName, Hierarchy hierarchy) {
        Properties props = new Properties();
        try {
            FileInputStream istream = new FileInputStream(configFileName);
            props.load(istream);
            istream.close();
        }
        catch (IOException e) {
            LogLog.error("Could not read configuration file [" + configFileName + "].", e);
            LogLog.error("Ignoring configuration file [" + configFileName + "].");
            return;
        }
        this.doConfigure(props, hierarchy);
    }

    public static void configure(String configFilename) {
        new PropertyConfigurator().doConfigure(configFilename, Category.defaultHierarchy);
    }

    public static void configure(URL configURL) {
        new PropertyConfigurator().doConfigure(configURL, Category.defaultHierarchy);
    }

    public static void configure(Properties properties) {
        new PropertyConfigurator().doConfigure(properties, Category.defaultHierarchy);
    }

    public static void configureAndWatch(String configFilename) {
        PropertyConfigurator.configureAndWatch(configFilename, 60000L);
    }

    public static void configureAndWatch(String configFilename, long delay) {
        PropertyWatchdog pdog = new PropertyWatchdog(configFilename);
        pdog.setDelay(delay);
        pdog.start();
    }

    public void doConfigure(Properties properties, Hierarchy hierarchy) {
        String disableStr;
        String value = properties.getProperty("log4j.debug");
        if (value == null && (value = properties.getProperty("log4j.configDebug")) != null) {
            LogLog.warn("[log4j.configDebug] is deprecated. Use [log4j.debug] instead.");
        }
        if (value != null) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(value, true));
        }
        String override = properties.getProperty("log4j.disableOverride");
        hierarchy.overrideAsNeeded(override);
        if (override == null && (disableStr = properties.getProperty("log4j.disable")) != null) {
            hierarchy.disable(disableStr);
        }
        this.configureRootCategory(properties, hierarchy);
        this.configureCategoryFactory(properties);
        this.parseCatsAndRenderers(properties, hierarchy);
        LogLog.debug("Finished configuring.");
        this.registry.clear();
    }

    public void doConfigure(URL configURL, Hierarchy hierarchy) {
        Properties props = new Properties();
        LogLog.debug("Reading configuration from URL " + configURL);
        try {
            props.load(configURL.openStream());
        }
        catch (IOException e) {
            LogLog.error("Could not read configuration file from URL [" + configURL + "].", e);
            LogLog.error("Ignoring configuration file [" + configURL + "].");
            return;
        }
        this.doConfigure(props, hierarchy);
    }

    void configureCategoryFactory(Properties props) {
        String factoryClassName = OptionConverter.findAndSubst(CATEGORY_FACTORY_KEY, props);
        if (factoryClassName != null) {
            LogLog.debug("Setting category factory to [" + factoryClassName + "].");
            this.categoryFactory = (CategoryFactory)OptionConverter.instantiateByClassName(factoryClassName, class$org$apache$log4j$spi$CategoryFactory == null ? (class$org$apache$log4j$spi$CategoryFactory = PropertyConfigurator.class$("org.apache.log4j.spi.CategoryFactory")) : class$org$apache$log4j$spi$CategoryFactory, this.categoryFactory);
        }
    }

    void configureRootCategory(Properties props, Hierarchy hierarchy) {
        String value = OptionConverter.findAndSubst(ROOT_CATEGORY_PREFIX, props);
        if (value == null) {
            LogLog.debug("Could not find root category information. Is this OK?");
        } else {
            Category root;
            Category category = root = hierarchy.getRoot();
            synchronized (category) {
                this.parseCategory(props, root, ROOT_CATEGORY_PREFIX, INTERNAL_ROOT_NAME, value);
            }
        }
    }

    protected void parseCatsAndRenderers(Properties props, Hierarchy hierarchy) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.startsWith(CATEGORY_PREFIX)) {
                Category cat;
                String categoryName = key.substring(CATEGORY_PREFIX.length());
                String value = OptionConverter.findAndSubst(key, props);
                Category category = cat = hierarchy.getInstance(categoryName, this.categoryFactory);
                synchronized (category) {
                    this.parseCategory(props, cat, key, categoryName, value);
                    this.parseAdditivityForCategory(props, cat, categoryName);
                    continue;
                }
            }
            if (!key.startsWith(RENDERER_PREFIX)) continue;
            String renderedClass = key.substring(RENDERER_PREFIX.length());
            String renderingClass = OptionConverter.findAndSubst(key, props);
            this.addRenderer(hierarchy, renderedClass, renderingClass);
        }
    }

    void parseAdditivityForCategory(Properties props, Category cat, String categoryName) {
        String value = OptionConverter.findAndSubst(ADDITIVITY_PREFIX + categoryName, props);
        LogLog.debug("Handling log4j.additivity." + categoryName + "=[" + value + "]");
        if (value != null && !value.equals("")) {
            boolean additivity = OptionConverter.toBoolean(value, true);
            LogLog.debug("Setting additivity for \"" + categoryName + "\" to " + additivity);
            cat.setAdditivity(additivity);
        }
    }

    void parseCategory(Properties props, Category cat, String optionKey, String catName, String value) {
        LogLog.debug("Parsing for [" + catName + "] with value=[" + value + "].");
        StringTokenizer st = new StringTokenizer(value, ",");
        if (!value.startsWith(",") && !value.equals("")) {
            if (!st.hasMoreTokens()) {
                return;
            }
            String priorityStr = st.nextToken();
            LogLog.debug("Priority token is [" + priorityStr + "].");
            if (priorityStr.equalsIgnoreCase("inherited") && !catName.equals(INTERNAL_ROOT_NAME)) {
                cat.setPriority(null);
            } else {
                cat.setPriority(OptionConverter.toPriority(priorityStr, Priority.DEBUG));
            }
            LogLog.debug("Category " + catName + " set to " + cat.getPriority());
        }
        cat.removeAllAppenders();
        while (st.hasMoreTokens()) {
            String appenderName = st.nextToken().trim();
            if (appenderName == null || appenderName.equals(",")) continue;
            LogLog.debug("Parsing appender named \"" + appenderName + "\".");
            Appender appender = this.parseAppender(props, appenderName);
            if (appender == null) continue;
            cat.addAppender(appender);
        }
    }

    Appender parseAppender(Properties props, String appenderName) {
        Appender appender = this.registryGet(appenderName);
        if (appender != null) {
            LogLog.debug("Appender \"" + appenderName + "\" was already parsed.");
            return appender;
        }
        String prefix = APPENDER_PREFIX + appenderName;
        String layoutPrefix = prefix + ".layout";
        appender = (Appender)OptionConverter.instantiateByKey(props, prefix, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = PropertyConfigurator.class$("org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
        if (appender == null) {
            LogLog.error("Could not instantiate appender named \"" + appenderName + "\".");
            return null;
        }
        appender.setName(appenderName);
        if (appender instanceof OptionHandler) {
            Layout layout;
            if (appender.requiresLayout() && (layout = (Layout)OptionConverter.instantiateByKey(props, layoutPrefix, class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = PropertyConfigurator.class$("org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null)) != null) {
                appender.setLayout(layout);
                LogLog.debug("Parsing layout options for \"" + appenderName + "\".");
                PropertySetter.setProperties(layout, props, layoutPrefix + ".");
                LogLog.debug("End of parsing for \"" + appenderName + "\".");
            }
            PropertySetter.setProperties(appender, props, prefix + ".");
            LogLog.debug("Parsed \"" + appenderName + "\" options.");
        }
        this.registryPut(appender);
        return appender;
    }

    void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    Appender registryGet(String name) {
        return (Appender)this.registry.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

