/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/util/struct/SnapshotDataBlockOld.java,v $
 * $Author: asullivan $ $Revision: 1.1.1.1 $ $Date: 2003/08/26 19:02:31 $
 *
 */

package com.postgres.replic.util.struct;

import java.util.*;

public class SnapshotDataBlockOld implements  DataConst {
    private CommandType snapCommand;
    private String param;

    // Array list of Strings:
    private ArrayList dataArray = new ArrayList();


    public SnapshotDataBlockOld(CommandType snapCommand, String param)
    throws Exception {
        if (param == null || param.trim().equals("")) {
            throw new Exception("SnapshotDataBlockOld:: 'param' name may not be empty");
        }
        this.param = param;
        this.snapCommand = snapCommand;
    }

    public void add(String data) {
         dataArray.add(data);
    }

    public String get(int i) {
         return (String) dataArray.get(i);
    }

    public int getInt(int i) {
         return (new Integer((String) dataArray.get(i))).intValue();
    }

    public void remove(int i) {
         dataArray.remove(i);
    }

    public int size() {
        return dataArray.size();
    }

    public CommandType getCommand(){
        return snapCommand;
    }

    public int getCommandInt(){
        return snapCommand.getCommand();
    }

    public String getParam(){
        return param;
    }

    public long getParamLong() throws Exception {
        long rc = 0;
        try {
            rc = (new Long(param)).longValue();
        } catch (Exception e) {
            throw new Exception("SnapshotdataBlock::getParamLong: " + e.toString());
        }
        return rc;
    }
}
