#!/usr/bin/env python
            
"""
   csvck.py checks csv files

usage: charge_psl.py -f <csv file> -o <output csv file> -l <log file> -s <separator> [-h]

  -h: this help
  -f: csv file
  -o: csv file (output)
  -l: log file
  -s: separator 
"""

from csv import *
import getopt
import sys
from string import *

class CSVCk(CSV):
	def __init__(self, file = '/dev/stdin', output = sys.stdout, log = LOG('/dev/stderr'), separator = '|'):
		CSV.__init__(self, file, log, separator)
		self.first_line = 1
		self.output = output
		self.nb_fields = 0
		self.nb_missing_fields = 0
		
	def load_line(self, line):

		l = len(line)

		if not l: return
		
		if self.first_line:
			self.nb_fields = l
			self.first_line = 0
			
		if self.nb_missing_fields:
			self.output.write(self.sep)
			if l < self.nb_missing_fields:
				self.output.write(join(line,self.sep))
				self.nb_missing_fields = self.nb_missing_fields - l
			else:
				self.output.write(join(line[:self.nb_missing_fields],self.sep))
				self.output.write('\n')
				self.nb_missing_fields_sav = self.nb_missing_fields
				self.nb_missing_fields = 0				
				self.load_line(line[self.nb_missing_fields_sav:])
		else:
			if l < self.nb_fields:
				self.output.write(join(line,self.sep))
				self.nb_missing_fields = self.nb_fields - l
			else:
				self.output.write(join(line[:self.nb_fields],self.sep))
				self.output.write('\n')
				self.load_line(line[self.nb_fields:])
				
def main():
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'l:f:o:hs:')
	except getopt.error, msg:
		usage(msg)

	separator = '|'
	file = '/dev/stdin'
	output = sys.stdout
	logfile = '/dev/stderr'
	
	for o, a in opts:
		if o == '-f': file=a
		if o == '-l': logfile=a
		if o == '-h': usage('')
		if o == '-s': separator=a
		if o == '-o': output=open(a,'w')
		if o == '-s': separator=a
			
	log = LOG(logfile)

	csvck = CSVCk(file, output, log, separator)
	csvck.load()
		
if __name__ == '__main__':
	main()
