#!/usr/bin/perl

use XML::Parser;

$|=1;
#=============================
#
#      SUB's


sub usage {
    print "usage:\n
\tpgml2struct.pl -h : ceci
\tpgml2struct.pl -f 'simplified pgml file'
\tpgml2struct.pl [ -o 'output file'] 
\tpgml2struct.pl [ -s ] => print out optionnal init instructions\n";
}



#===== mieux que getopts
sub getArgs {
    my @args=@_;
    my $oldKey="";
    my %opts=();
    for $el (@args) {
	if ($el=~/^-/) {
	    $el=~s/-+//g;
	    $opts{$el}="";
	    $oldKey=$el;
	}
	else {
	    $opts{$oldKey}=$el;
	}
    }
    return %opts;
}


sub table {    #Start Handler
    my @var=@_;
    my %keys;
    $curType=$var[1];

#    print "-- Start ".$var[2]."\n";
    for ($i=2;$i<$#var;$i+=2) {
#	print $i."-".$var[$i]." ".$var[$i+1]."\n";
	$keys{$var[$i]}=$var[$i+1];
    }

    $Table=$keys{name};
    $curTable="struct".$keys{name};

    print "insert into structtable (champ,denom,editable,rang,isoid,type,defaut,disp) VALUES ('".$Table."','".$Table."',1,14,'t','Config',NULL,NULL);\n";
    print "create table struct".$Table." () inherits (structtable);\n";
    
    #Gestion des relations d'heritage:
    if (exists $keys{isa})
    {
	print "insert into struct".$Table." select * from struct".$keys{isa}.";\n";
    }
    else 
    {
	print "insert into $curTable (champ,denom,editable,rang,isoid,type,defaut,disp) VALUES ('uid','pg_id',0,99,'t','int4',NULL,NULL);\n";
    }

}


sub table_ {    #End Handler
    my ($xparse,$type,$a1,$val1)=@_;
    $curTable="";
    $curType="";
#    
}

sub attribute {
    if ($curType ne "table")
    {
	return ;
    }
    my @var=@_;
    my %keys;
    for ($i=2;$i<$#var;$i+=2) {
#	print $i."-".$var[$i]." ".$var[$i+1]."\n";
	$keys{$var[$i]}=$var[$i+1];
    }
    my %attr;
    if ( exists ($keys{references})) {
	$keys{type}="oid";
	$reference=$keys{references};
    }
    else
    {
	$reference="";
    }
    
    if ( ($keys{name} eq "authmodif") || ($keys{name} eq "authcrea")) {
	$reference="personne";
	$keys{type}="oid";
    }

    print "insert into $curTable (champ,denom,editable,rang,isoid,type,defaut,disp) VALUES ('".$keys{name}."','".$keys{name}."',1,1,'t','".$keys{type}."',NULL,'$reference');\n";
    
}



#==========================
# MAIN


#------------------------
#                       |
#Gestion des entr%/1iso8859-15es :
my %opts=();
%opts=getArgs(@ARGV);

if((exists $opts{h}) || (exists $opts{help})) {
    &usage();
    exit 0;
}

if (exists $opts{f}) {
    $file=$opts{f};
} else {
    &usage();
    exit 0;
}

if (exists $opts{o}) {
    $output=$opts{o};
} else {
    $output="";
}
#                       |
#------------------------


#------------------------
#                       |
#Initialisation:

if ($output) {
    open(OUT,">$output");
    *STDOUT=*OUT;
}

#Creations necessaires (si param%/1iso8859-15tre -s):

if (exists $opts{s}) {
    print '
CREATE TABLE "structtable" (
	"champ" text,
	"denom" text,
	"editable" int4,
	"rang" int4,
	"isoid" bool,
	"type" text,
	"defaut" text,
	"disp" text,
	"uid" SERIAL PRIMARY KEY
);

CREATE TABLE "constantes" (
	"tva" float8 DEFAULT 0.206,
	"salairenet" float8 DEFAULT 10000,
	"defaultjh" float8,
	"uid" SERIAL PRIMARY KEY
);

insert into constantes (uid) values (1);


create function tva(date) returns float8 as \'select 0.206+0.01*((float8(age(\\\'April 4,2000\\\'::datetime,$1::datetime)::reltime)/(@(float8(age(\\\'April 4,2000\\\'::datetime,$1::datetime)::reltime)))-1)/2)\' language \'sql\';

CREATE FUNCTION "nextid" ( ) RETURNS int4 AS \'update constantes set uid=uid+1;select uid from constantes;\' LANGUAGE \'SQL\';

create table structstructtable () inherits (structtable) ;

INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'champ\',\'Champ\',1,0,\'t\',\'text\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'denom\',\'\',1,0,\'t\',\'text\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'editable\',\'\',1,0,\'t\',\'text\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'rang\',\'\',1,0,\'t\',\'text\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'isoid\',\'\',1,0,\'t\',\'text\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'type\',\'\',1,0,\'t\',\'text\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'defaut\',\'\',1,0,\'t\',\'text\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'uid\',\'pg_id\',0,0,\'t\',\'int4\',NULL);
INSERT INTO "structstructtable" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'disp\',\'\',1,0,\'t\',\'text\',NULL);

CREATE TABLE "structconstantes" (
)
inherits ("structtable");

INSERT INTO "structconstantes" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'tva\',\'TVA\',1,1,\'t\',NULL,NULL);
INSERT INTO "structconstantes" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'salairenet\',\'Salaire net\',1,1,\'t\',NULL,NULL);
INSERT INTO "structconstantes" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'defaultjh\',\'Prix jh (defaut)\',1,1,\'t\',NULL,NULL);
INSERT INTO "structconstantes" ("champ","denom","editable","rang","isoid","type","defaut") VALUES (\'uid\',\'pg_id\',0,9,\'t\',\'int4\',NULL);


';
}
# fin initialisation
#                       |
#------------------------




my $parser= new XML::Parser( Style => 'Subs');

$toto=$parser->parsefile( $file, ProtocolEncoding => 'ISO-8859-1'); 

close OUT;



#=================================
#
#         End Main
#
#=================================


