
import Globals
import Acquisition
from Globals import HTMLFile, Persistent, MessageDialog
from  Products.ZSQLMethods.SQL import *
import AccessControl
import OFS
from string import *
from urllib import *

class Pgt (
	Acquisition.Implicit,
	Persistent,
	AccessControl.Role.RoleManager,
	):
	"pgt."

	__ac_permissions__=(
		('View management screens', ('manage_main',)),
		('View', ('', 'index_html', 'getSelect_query', 'sqlselect', 'implementedSQLConnectionIDs', 'test','add_dtml_select','add_dtml_update')),
		('Change Pgt', ('manage_edit',), ('Manager',)),
		)

	manage_options=(
		{'label':'Properties', 'action':'manage_main'},
		{'label':'View', 'action':''},
		) + OFS.SimpleItem.SimpleItem.manage_options

	meta_type = 'Pgt'

	index_html = Globals.HTMLFile("pgt", globals())
	manage_main = Globals.HTMLFile("edit_pgt", globals())
	zsqlmethod = None

	def __init__(self, id, title, sqlconnectionid):
		self.id = id
		self.title = title
		self.connection_id = sqlconnectionid
		
	def getSelect_query(self):
		"get select query"
		return self._select_query

	def test(self):
		"ah d'accord, ca marche pas quand on de met pas de __doc__!"
		zsql = self.zsqlmethod()
		if zsql:
			return zsql.names()
		return "aarg"

	def implementedSQLConnectionIDs(self):
		"""Find SQL database connections in the current folder and above

		This function return a list of ids.
		Shameless stolen (with little modifications) from SQL.py
		"""
		ids={}
		have_id=ids.has_key
		StringType=type('')

		while self is not None:
			if hasattr(self, 'objectValues'):
				for o in self.objectValues():
					try:
						if (hasattr(o,'_isAnSQLConnection')
							and o._isAnSQLConnection
							and hasattr(o,'id')):
							#let's see if this DB is suported
							if not hasattr(o, 'database_type'):
								raise ImportError
							exec('import DBInfo.' + getattr(o, 'database_type'))

							id=o.id
							if type(id) is not StringType: id=id()
							if not have_id(id):
								if hasattr(o,'title_and_id'): o=o.title_and_id()
								else: o=id
								ids[id]=id
					except ImportError:
						#Database is not supported
						pass 
					if hasattr(self, 'aq_parent'): self=self.aq_parent
					else: self=None

		ids=map(lambda item: (item[1], item[0]), ids.items())
		ids.sort()
		return ids
	
	def add_dtml_index(self):
		return """
		<h2>%s</h2>
		<ul>
		<li><a href="select">Visualiser</a></li>
		<li><a href="insert">Creer</a></li>
		""" % self.id
		
	def add_dtml_select(self):
		"Generates dtml select query"
		zsql = self.zsqlmethod()
		if not zsql:
			return "no result"
		names = zsql.names()
		if not names:
			return "no fields"
		href = '<a href="update?' 
		for name in names:
			href = href + '%s=<dtml-var %s url_quote_plus null="">&' % (name, name)
		href = '%s">' % href[:-1]
		rowname = ""
		rowfield = ""
		for name in names:
			rowname = rowname + '<th>%s</th>' % name
			rowfield = rowfield + \
					   '<td>%s<dtml-var %s null=""></a></td>' % (href, name)
		return """
		<dtml-var standard_html_header>
		<a href="insert">New entry</a>
		<dtml-in zsql_select size=3 start=query_start>
		   <dtml-if sequence-start>
		     <dtml-if previous-sequence>
		       <a href="<dtml-var URL><dtml-var sequence-query>query_start=<dtml-var previous-sequence-start-number>">
			   (Previous <dtml-var previous-sequence-size> results)
			   </a>
		     </dtml-if previous-sequence>
			 <table border>
			 <tr>%s</tr>
			</dtml-if sequence-start>
			<tr>%s</tr>

			<dtml-if sequence-end>
			  </table>
		      <dtml-if next-sequence>
			    <a href="<dtml-var URL><dtml-var sequence-query>query_start=<dtml-var next-sequence-start-number>">
				(Next <dtml-var next-sequence-size> results)
				</a>
		      </dtml-if next-sequence>
		    </dtml-if sequence-end>
			<dtml-else>
			  There was no data matching this <dtml-var title_or_id> query.
		</dtml-in>
		<dtml-var standard_html_footer>
		""" % (rowname, rowfield)
	
	def add_dtml_insert(self):
		"Generates dtml insert query"
		zsql = self.zsqlmethod()
		if not zsql:
			return "no result"
		names = zsql.names()
		if not names:
			return "no fields"
		rowname = ""
		rowfield = ""
		for name in names:
			rowfield = rowfield + \
					   '<tr><td>%s</td><td><input type="text" name="%s">"</td></tr>\n' \
					   % (name, name)
		return """
		<dtml-var standard_html_header>
		<form action="insert_submit" method="post">
		<input type="hidden" name="zsql" value="zsql_insert">
		<table border>
		%s
		</table>
		<input type="submit">
		</form>
		<dtml-var standard_html_footer>
		""" % rowfield

	def add_dtml_insert_submit(self):
		"Generates dtml submit query (for edit & update)"
		return """
		<dtml-var standard_html_header>
		<dtml-in zsql_insert size=3 start=query_start>
		<a href=%s>Retour selection</a>
		</dtml-in>
		<dtml-var standard_html_footer>
		""" % self.id
	
	def add_dtml_update(self):
		"Generates dtml update(update) query"
		zsql = self.zsqlmethod()
		if not zsql:
			return "no result"
		names = zsql.names()
		if not names:
			return "no fields"
		rowname = ""
		rowfield = ""
		for name in names:
			rowfield = rowfield + \
					   '<tr><td>%s</td><td><input type="text" name="%s" value="<dtml-var %s null="">"</td></tr>\n' \
					   % (name, name, name)
		return """
		<dtml-var standard_html_header>
		<form action="update_submit" method="post">
		<input type="hidden" name="zsql" value="zsql_update">
		<table border>
		%s
		</table>
		<input type="submit">
		</form>
		<dtml-var standard_html_footer>
		""" % rowfield


	def add_dtml_update_submit(self):
		"Generates dtml submit query (for update & update)"
		return """
		<dtml-var standard_html_header>
		<dtml-in zsql_update size=3 start=query_start>
		<a href="select">Retour selection</a>
		</dtml-in>
		<dtml-var standard_html_footer>
		"""

	def manage_edit(self, title, REQUEST=None):
		"Edits the pgt's characteristics"
		self.title = title
		if REQUEST is not None:
			return Globals.MessageDialog(
				title='Edited',
				message='<strong>%s</strong> has been edited.' % self.id,
				action ='manage_main',
				)


Globals.default__class_init__(Pgt)

def manage_addPgt(self, id, title, sqlconnectionid, pgml, pgtml, REQUEST=None):
	"""
	Creates a pgt and install it in its parent Folder.
	The argument 'self' will be bound to the parent Folder.
	"""
	pgt = Pgt(id, title, sqlconnectionid)
	#self._setObject(id, pgt)

	import common
	import pgmlgraph
	import pgtmlgraph

	if not pgml: return 'error : missing database pgml file'
	if not pgtml: return 'error : missing ptgml file'

	b = pgmlgraph.PgmlGraph()
	b.read(pgml)
	b.simplify()

	g = pgtmlgraph.PgtmlGraph(b)
	g.read(pgtml)
 
  
	#output ="manage_addProduct/Pgt/add_pgt?my_id=%s" % g.name
	select = g.get_select()
	select_args = ''
	select_query = select[0]
 
	insert = g.get_insert()
	insert_args = joinfields(insert[3], ' ')
	insert_query= "SELECT %s(%s)" % (insert[1], joinfields(map(lambda f:"'<dtml-var %s>'"%f, insert[3]),','))

	update = g.get_update()
	update_args = joinfields(update[3], ' ')
	update_query = "SELECT %s(%s)" % (update[1], joinfields(map(lambda f:"'<dtml-var %s>'"%f, update[3]),','))


	# Add Pgt Folder
	self.manage_addFolder(pgt.id, '') 
	folder = self._getOb(pgt.id)
	
	# Add DTML Search interface
	folder.manage_addDTMLDocument('index_html', '', pgt.add_dtml_index() ) 

	# Add ZSQLMethods
	folder._setObject('zsql_select',
					SQL('zsql_select' , '', sqlconnectionid, select_args, select_query))
	folder._setObject('zsql_insert',
					SQL('zsql_insert', '', sqlconnectionid, insert_args, insert_query))
	folder._setObject('zsql_update',
					SQL('zsql_update', '', sqlconnectionid, update_args, update_query))
	
	zsqlmethod = folder._getOb('zsql_select')
	if zsqlmethod:
		pgt.zsqlmethod = zsqlmethod
	else:
		pgt.zsqlmethod = 'grr'

	# Add DTML Search interface
	try:
		folder.manage_addDTMLDocument('select', '', pgt.add_dtml_select() ) 
	except AttributeError:
		folder.manage_addDocument('select', '', pgt.add_dtml_select() )
	
	# Add DTML Update interface
	try:
		folder.manage_addDTMLDocument('update', '', pgt.add_dtml_update() ) 
	except AttributeError:
		folder.manage_addDocument('update', '', pgt.add_dtml_update() )
	
	# Add DTML Update submit interface
	try:
		folder.manage_addDTMLDocument('update_submit', '', pgt.add_dtml_update_submit() ) 
	except AttributeError:
		folder.manage_addDocument('update_submit', '', pgt.add_dtml_update_submit() )
	
	# Add DTML Insert interface
	try:
		folder.manage_addDTMLDocument('insert', '', pgt.add_dtml_insert() ) 
	except AttributeError:
		folder.manage_addDocument('insert', '', pgt.add_dtml_insert() )
	
	# Add DTML Insert submit interface
	try:
		folder.manage_addDTMLDocument('insert_submit', '', pgt.add_dtml_insert_submit() ) 
	except AttributeError:
		folder.manage_addDocument('insert_submit', '', pgt.add_dtml_insert_submit() )
	
	if REQUEST is not None:
		return self.manage_main(self, REQUEST)

manage_addPgtForm = Globals.HTMLFile('add_pgt', globals())






