# $Id: admin_mgr.pm,v 1.2 2003/12/20 04:14:51 mig Exp $
######################################
# Comas - Conference Management System
######################################
# Copyright 2003 CONSOL
# Congreso Nacional de Software Libre (http://www.consol.org.mx/)
#   Gunnar Wolf <gwolf@gwolf.cx>
#   Manuel Rabade <mig@mig-29.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################

######################################
# Module: Comas::HTML::committee::admin_mgr
# Manages administrators and his tasks 
######################################
# Depends on:
#
# Comas::Person - Handles the interaction with a person for Comas
# Comas::Proposal - Handles the interaction with a person for Comas
# Comas::Admin - Manage administrative tasks for a Comas database
# Comas::HTML::common - Common functions for the HTML FrontEnd
# HTML::Template - Perl module to use HTML Templates
# Data::FormValidator - Validates user input based on input profile
# HTML::FromText - Marks up plain text as HTML

# This module is not meant to be called on its own, it should be called from
# Comas::HTML.

package Comas::HTML::committee::admin_mgr;

use strict;
use warnings;
use Carp;

use Comas::Admin;
use Comas::Person;
use Comas::Proposal;
use Comas::HTML::common qw(:all);

use HTML::Template;
use Data::FormValidator;
use HTML::FromText;

use Exporter;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw( admin_mgr_menu admin_mgr_edit );
our %EXPORT_TAGS = (all => [@EXPORT_OK]);

=head1 NAME
    
Comas::HTML::committee::admin_mgr

=head1 SYNOPSIS

This module is not meant to be used by itself, but as an auxiliary to
L<Comas::HTML>. Please check L<Comas::HTML>'s documentation, in the
B<Front End Tasks> section, for further details on the usage for this functions.

=head1 SEE ALSO

L<Comas::HTML|Comas::HTML> module documentation

=head1 AUTHOR

Gunnar Wolf, gwolf@gwolf.cx

Manuel Rabade, mig@mig-29.net

Comas has been developed for CONSOL, Congreso Nacional de Software Libre,
http://www.consol.org.mx/

=head1 COPYRIGHT

Copyright 2003 Gunnar Wolf and Manuel Rabade

This library is free software, you can redistribute it and/or modify it
under the terms of the GPL version 2 or later.

=cut

sub admin_mgr_menu {
    my ($template);
    my $h = shift;

    unless($h->_ck_committee_task) {
        return $h->committee_menu('NOT_AUTHORIZED');
    }
    
    $template = HTML::Template->new(filename=>
                                    'committee/admin_mgr/menu.tmpl',
                                    path => $h->{-config}->{-tmpl_path},
                                    die_on_bad_params => 0, cache => 1);
    
    return $template->output;
}

1;

# $Log: admin_mgr.pm,v $
# Revision 1.2  2003/12/20 04:14:51  mig
# - Agrego tags Id y Log que expanda el CVS
#
