%conv = (
'standard' => {
         0 => 'SQL_ALL_TYPES',
         1 => 'SQL_CHAR',
         2 => 'SQL_NUMERIC',
         3 => 'SQL_DECIMAL',
         4 => 'SQL_INTEGER',
         5 => 'SQL_SMALLINT',
         6 => 'SQL_FLOAT',
         7 => 'SQL_REAL',
         8 => 'SQL_DOUBLE',
         9 => 'SQL_DATE',
        10 => 'SQL_TIME',
        11 => 'SQL_TIMESTAMP',
        12 => 'SQL_VARCHAR',
        -1 => 'SQL_LONGVARCHAR',
        -2 => 'SQL_BINARY',
        -3 => 'SQL_VARBINARY',
        -4 => 'SQL_LONGVARBINARY',
        -5 => 'SQL_BIGINT',
        -6 => 'SQL_TINYINT',
        -7 => 'SQL_BIT',
        -8 => 'SQL_WCHAR',
        -9 => 'SQL_WVARCHAR',
       -10 => 'SQL_WLONGVARCHAR'
				},
'mysql'    => {
        'VARCHAR'    =>  12,
        'DECIMAL'    =>   3,
        'TINYINT'    =>  -6,
        'SMALLINT'   =>   5,
        'INTEGER'    =>   4,
        'FLOAT'      =>   7,
        'DOUBLE'     =>   8,
        'TIMESTAMP'  =>   11,
        'BIGINT'     =>   -5,
        'MIDDLEINT'  =>   4,
        'DATE'       =>   9,
        'TIME'       =>   10,
        'DATETIME'   =>   11,
        'YEAR'       =>   5,
        'DATE'       =>   9,
        'ENUM'       =>   12,
        'SET'        =>   12,
        'BLOB'       =>   -1,
        'TINYBLOB'   =>   -1,
        'MEDIUMBLOB' =>   -1,
        'LONGBLOB'   =>   -1
				},
'Pg'       => {
        'BOOL'       =>   0,
        'INT8'       =>   8,
        'INT2'       =>   5,
        'INT4'       =>   4,
        'TEXT'       =>  12,
        'FLOAT4'     =>   6,
        'FLOAT8'     =>   7,
        'ABSTIME'    =>  10,
        'RELTIME'    =>  10,
        'TINTERVAL'  =>  11,
        'MONEY'      =>   0,
        'BPCHAR'     =>  12,
        'VARCHAR'    =>  12,
        'DATE'       =>   9,
        'TIME'       =>  10,
        'DATETIME'   =>  11,
        'TIMESPAN'   =>  11,
        'TIMESTAMP'  =>  10
        },
'Oracle'    => {
        'LONG_RAW'   =>  -4,
        'RAW'        =>  -3,
        'LONG'       =>  -1,
        'CHAR'       =>   1,
        'NUMBER'     =>   3,
        'DOUBLE'     =>   8,
        'DATE'       =>  11,
        'VARCHAR2'   =>  12
        },
'csv'       => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'ffl'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'xml'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'html'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'record'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'textfilter'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'transfer'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'binaryfilter'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
);

my $hstd = $conv{standard};
sub x {
foreach my $drv (keys %conv) {
	next if ($drv eq 'standard');
	my $hdrv = $conv{$drv};
	foreach my $dt (keys %{$conv{$drv}}) {
	print "insert into datatype (stdname, driverid, datatypeid)
		(select distinct '$hstd->{$hdrv->{$dt}}'::varchar, driverid, '$dt'::varchar from driver
		 where driverid like '$drv%'::varchar);\n";
# print "$drv ; $dt ; $hstd->{$hdrv->{$dt}}\n";
}
}
}

foreach my $stdid (keys %{$hstd}) {
	print "insert into datatype (stdname, driverid, datatypeid) values ('$hstd->{$stdid}', '==standardsql==', '$stdid');\n"
}
