#!/usr/bin/perl
use strict;
use DBI;
use Getopt::Long;
use Cwd;
use File::Basename;


sub Question {
	my ($question, $answer, $pattern) = (shift, shift, shift);

	my $ans;
	while (1) {
		print  "$question [$answer] : ";
		$ans = <STDIN>;
		chomp $ans;
		if (defined($pattern)) { $ans = undef unless ($ans =~ /$pattern/); }
		if ($answer) { return $answer unless ($ans); }
		last if $ans;

	}
	return $ans;
}

sub YesNo {
	my ($question, $answer) = (shift, shift);
	while (1) {
		my $ans = Question($question . " (YES/NO)", $answer);
		$ans = uc($ans);
		if (($ans eq "YES") or ($ans eq "Y")) { return "yes"; }
		elsif (($ans eq "NO") or ($ans eq "N")) { return "no"; }
		print "\n";
	}
}

sub Usage {
	die "Usage initialize install {Q|R} dbname aliphepw [contextid]\n";
}

my ($dsn, $user, $pwd);
my ($v2server, $v2database, $v2user, $v2pwd);



my %config;
my $db;
sub getparam  {
	Getopt::Long::GetOptions(\%config, "dsn=s", "user=s", "pwd=s", "flow=s", "ofile=s", "context=s");
#	print " ==== Base de donnes Aliphe V1====\n";
	my $usage = "perl $0 --dsn=dbi:Pg:dbname=aliphev2db --user=aliphe --pwd=aliphe --flow=2238   --context=aliphe";
	unless ($config{user} and $config{pwd} and $config{flow} and $config{context} and $config{dsn}) {
		print  STDERR "ERROR : Usage $usage\n";
		die;
	}
#	print " ==== Base de donnes Aliphe V1====\n";
	$config{dsn} = Question ("DBI DSN ") unless ($config{dsn});
	$config{user}     = Question ("Utilisateur Postgres", "aliphe") unless ($config{user});
	$config{pwd}     = Question ("Mot de passe Postgres", "aliphe") unless ($config{pwd});
	$config{flow} = undef unless ($config{flow} =~ /^[[:digit:]]+$/);
	$config{flow}    = Question ("Id du flux a migrer", undef, '^[[:digit:]]*$') unless ($config{flow});
	$config{context}    = Question ("Id du flux a migrer") unless ($config{flow});

	$config{cwd} = Cwd::cwd();
 
	my ($name,$path,$suffix) = fileparse($0);

	chdir $path;
	my $path = Cwd::cwd();
	chdir "..";
	my $cwd = Cwd::cwd();
	push @INC, "$cwd";

	chdir $path;

	require tools::cafUtils;
	require tools::cafDbg;
        require Data::Dumper;
        require connectors::refDBI;
        require connectors::ObjHier;
	$config{opath} = $path;
	my $date = cafUtils->datetime1();
	$config{ofile} = $config{context} . "_" . $config{flow} . "_" . $date;
	$config{opackage} = $config{context} . "_" . $config{flow};
	$config{ofile} =~ s/[\/]/_/g;
	$config{ofile} =~ s/ ..:..:...*//g;
	$config{ofile} .= ".pm";
	$config{COMMENTS} =~ "Generated by $0 : $date";
	
        my @a = split(":", $config{dsn});
        $db = {
                connector      => {
                        driverid     => $a[1],
                        protocolid   => "DBI",
                        dbidsn       => $config{dsn},
                },
                user                 => { username => $config{user}, password => $config{pwd}, },
                userid               => { username => $config{user}, password => $config{pwd}, },
                _ATTRS               => {
                PrintError        => 0,
                RaiseError        => 1,
                AutoCommit        => 0,
                },
        };

}

sub executeqry {
	my $dbh = shift;
	my $qry = shift;
	my $keyfld = shift;
	my $p = shift;
#	$p=1;

	if ($p) { print "\n\nQUERY = $qry\n\n"; }
	my $sth = $dbh->prepare($qry);
	$sth->execute();
	my @ret = ();
	while (my $row = $sth->fetchrow_hashref()) {
		my %row = %{$row};
		push @ret, \%row;
	}
	$sth->finish();
	\@ret;
}


getparam();

my $migrobjs = {
		objects => {},
		thedump => {},
		attributes => {},
		mapping => [],
		objscr => {},
		otherobj => {},
		config => \%config,
		mapping => {}
	};

my $objects = $migrobjs->{objects};
my $thedump = $migrobjs->{thedump};
my $attributes = $migrobjs->{attributes};
my $otherobj = $migrobjs->{otherobj};
my $objscr = $migrobjs->{objscr};
my $mapping = $migrobjs->{mapping};



my $dbh;
eval {

	require Data::Dumper;

#	$dbh = DBI->connect ($config{dsn}, $config{user}, $config{pawd}, {RaiseError => 1});
	$dbh = refDBI->Connect($db);
#	print "ObjHier";
	my $objHier = ObjHier->new($dbh, "REPOSITORY", "NOCONTEXT", "NOCONTEXT");
#	print "gethierarchy";
	$objHier->gethierarchy([$config{flow}]);
	my @allobjs = $objHier->allobjects();
	{
		my %h =  map { $_ => $objHier->getobject($_)} @allobjs;
		foreach my $obj (values %h) {
			if ($obj->{parsetext}) { $obj->{parsetext} = $obj->{parsetext}{parsetext}; }
		}
		$migrobjs->{thedump} = \%h;
		$thedump = $migrobjs->{thedump};
		
	}
	{
		my %h = map { $_ => { last_modified => $thedump->{$_}{modified}} } @allobjs;
		$migrobjs->{objects} = \%h;
		$objects = $migrobjs->{objects};
	}
	$migrobjs->{objscr} = $objHier->{SCRIPTLIST};

	{
		my %h = ();
		foreach my $km (keys %{$objHier->{MAPPFIELDS} || {}}) {
			my @a = values %{$objHier->{MAPPFIELDS}{$km} || {}};
			$h{$km} = \@a;
		}
		$migrobjs->{mapping}    = \%h; #$objHier->{MAPPFIELDS}; #\%h;
	}


	$migrobjs->{otherobj} = $objHier->{OTHEROBJECTS} || {};

	{
		my %h = ();
		foreach my $km (keys %{$objHier->{ATTRIBUTES} || {}}) {
			my %a = map { $_->{attrdefid} => $_->{attrvalue} } @{$objHier->{ATTRIBUTES}{$km} || []};
			$h{$km} = \%a;
		}
		$migrobjs->{attributes} = \%h; 
	}

	my $query = $dbh->newquery();
	$query->query("select * from attrdef");
	my $rows = $dbh->hexecfetchall($query);

	$migrobjs->{attrdefs} = $rows;

	my $dump = Data::Dumper->new([$migrobjs], ["migrobjs"]);
	my $ptext = $dump->Dump;
	chdir $config{opath};
	open FOUT, ">$config{ofile}";
	print FOUT "package $config{opackage};\n";
	print FOUT $ptext, "\n";
	print FOUT "sub objectsrefs { return \$migrobjs; }\n\n1;\n";
	close FOUT;
	chdir $config{cwd};
	$dbh->disconnect();

};

if ($@) { print "$@ " . "\n"; }

1;
