=cut

XS_CHILDCOUNT
XS_CHILDPORT
XS_CLIENTPORT
XS_HOSTALLOW
XS_HOSTDENY
XS_MAXCHILDMSGSIZE
XS_MAXCLIENTMSGSIZE
XS_MAXMSGSIZE
XS_RECSEP
XS_REUSE
XS_SCRIPTTO

=cut


=cut
my $xmlClients = {
	socket => {
		id => {
			ipAdress  => '',
			userid    => '',
			sessionid => '',
			group1    => '',
			group2    => '',
			group3    => '',
		},
		lastAccess => time(),
		RequestQueue => [],
		ResponseQueue => [],
	}
}





'<Request>
	<service>ScriptId</service>
	<Parameters>
		<paramName>Value</paramName>
		<structName>
			<fieldName>Value</fieldName>
			<fieldName>Value</fieldName>
		</structName>
		<arrayName>Value</arrayName> # Array 
		<arrayName>Value</arrayName> # Array 
		<arrayName>Value</arrayName> # Array 
	</parameters>
</Request>'

'<Response>
	<Request> .... </Request>
	<Result>
		<paramName>Value</paramName> # Simple parameter
		<structName>  # struct
			<fieldName>Value</fieldName>
			<fieldName>Value</fieldName>
		</structName> # end of struct
		<arrayName>Value</arrayName> # Array 
		<arrayName>Value</arrayName> # Array 
		<arrayName>Value</arrayName> # Array 
		...
	</Result>
</Response>'



Cleints => {
		$socket => {
			login =>
			ipaddress =>
			attr1     =>
			attr2     =>
			attr3     =>
		}
}

Response => {
	theResponse => [ clientRequest, Response ]
	Client =>
	DestCrit =>
}

Request => {
	requestId => { Client, clientRequest, }
}

Processing => {
	requestId => {
		ClientId,
		ServerId,
		clientRequest,
	}
}

clientResp => {
	clientId => [ Responses ]
}


CleintIds => {
	clientIds => $socket; # $socket->peerport . $socket->peerhost . time();
}
=cut

my %msgTypes = (
	REQUEST                   => { REQUEST => 1 },
	BROADCASTCHILDS           => { BROADCASTCHILDS => 1 },
	BROADCASTCLIENTS          => { BROADCASTCLIENTS => 1 },
	STATUS                    => { STATUS => 1 },
	GETVAR                    => { GETVAR => 1 },
	SETVAR                    => { SETVAR => 1 },
	LOCKVAR                   => { LOCKVAR => 1 },
	UNLOCKVAR                 => { UNLOCKVAR => 1 },
	REPLAY                    => { REPLAY => 1 },
	TERMINATE                 => { TERMINATE => 1 },
);


my $xmlSocketData;

sub XSGetVar {
	my $self = shift;
	my $varName = shift;
	my $lockType = shift;
	my $sig      = shift;
	my $varValue = shift;

	if (exists ($xmlSocketData->{LOCKEDVARS}{$varName})) {
		my @locker = keys %{$xmlSocketData->{LOCKEDVARS}{$varName}};
		my $lockedSince = $xmlSocketData->{LOCKEDVARS}{$varName}{$locker[0]};
		delete $xmlSocketData->{LOCKEDVARS}{$varName} if ((time - $lockedSince) > 10);
	}

	if ($lockType eq "UNLOCK") {
		my $lockedSince;
		if ($lockedSince = $xmlSocketData->{LOCKEDVARS}{$varName}{$sig}) {
			delete $xmlSocketData->{LOCKEDVARS}{$varName};
			return { VARNAME => $varName, STATUS => "UNLOCKED" };
		}
		else {
			if (exists ($xmlSocketData->{LOCKEDVARS}{$varName})) {
				return { VARNAME => $varName, STATUS => "LOCKED", ERROR => "NOTYOURLOCK" };
			}
			else {
				return { VARNAME => $varName, STATUS => "UNLOCKED", ERROR => "NOTLOCKED" };
			}
		}
	}
	elsif ($lockType eq "SHARED") {
		if (exists ($xmlSocketData->{LOCKEDVARS}{$varName})) {
			return { VARNAME => $varName, ERROR => "LOCKED" };
		}
		else {
			return { VARNAME => $varName, VARVALUE => $xmlSocketData->{CHILDVARS}{$varName} };
		}
	}
	elsif ($lockType eq "EXCL") {
		if (exists ($xmlSocketData->{LOCKEDVARS}{$varName})) {
			return { VARNAME => $varName, ERROR => "LOCKED" };
		}
		else {
			$xmlSocketData->{LOCKEDVARS}{$varName}{$sig}=time();
			return { VARNAME => $varName, VARVALUE => $xmlSocketData->{CHILDVARS}{$varName}, STATUS => "LOCKED" };
		}
	}
	elsif ($lockType eq "SET") {
		if ($lockedSince = $xmlSocketData->{LOCKEDVARS}{$varName}{$sig}) {
			$xmlSocketData->{CHILDVARS}{$varName} = $varValue;
			delete $xmlSocketData->{LOCKEDVARS}{$varName};
			delete $xmlSocketData->{CHILDVARS}{$varName} unless (defined($varValue));
			return { VARNAME => $varName, VARVALUE => $varValue, STATUS => "UNLOCKED" };
		}
	}
}

sub XSOpenSession {
	my $self = shift;
	my $userid = shift;
	my $passwd = shift;
	my $ip     = shift;

	my $dbh = $self->QueueDbhAutocommit();
	my $sessionId;
	eval { $sessionId = $dbh->rtnewsession(userid => $userid, userpass => $passwd, ipaddress => $ip); };
	if ($@) { return undef; }
	return $sessionId;
}

sub XSCanAccept {
	my $self = shift;
	my $sock = shift;

	unless ($XmlSocket->{HOSTDENY}) {
		my $hostPattern = $attrs->{XS_HOSTDENY};
		my @hostDeny = split(/[,;]/, $hostPattern);
		foreach $pat (@hostDeny) {
			$pat =~ s/\./\\\./g;
			$pat =~ s/\*/\.\*/g;
		}
		$XmlSocket->{HOSTDENY} = \@hostDeny;
	}

	unless ($XmlSocket->{HOSTALLOW}) {
		my $hostPattern = $attrs->{XS_HOSTALLOW};
		my @hostAllow = split(/[,;]/, $hostPattern);
		foreach $pat (@hostAllow) {
			$pat =~ s/\./\\\./g;
			$pat =~ s/\*/\.\*/g;
		}
		$XmlSocket->{HOSTALLOW} = \@hostAllow;
	}

	my $perrhost = $sock->peerhost();
	foreach $pat (@{$XmlSocket->{HOSTDENY}}) {
		if ($peerhost =~ /^$pat$/) { return undef; }
	}

	foreach $pat (@{$XmlSocket->{HOSTALLOW}}) {
		if ($peerhost =~ /^$pat$/) { return 1; }
	}
	return undef;
}



sub XSClientId {
	my $self = shift;
	my $clientPort = shift;
	my $clientAddre = shift;

	
	my $addr = sprintf("%X%X%X", unpack("L", $socket->peeraddr), $socket->peerport, time());
	return $addr;
}

sub XSRequestId {
	my $self = shift;
	my $clientPort = shift;
	my $clientAddre = shift;

	my $rand = int(rand (1) * 100000000);
	my $addr = sprintf("%X%X%X", unpack("L", $socket->peeraddr), $socket->peerport, time(), $rand);
	return $addr;
}

sub XSOpenSockets {
	my $self = shift;
	my $attrs = shift;

	my $clientPort = $attrs->{XS_CLIENTPORT};
	my $childPort = $attrs->{XS_CHILDPORT};
	my $reuse = $attrs->{XS_REUSE};
	my ($clientSocket, $childSocket);

	if (my $clientAddress = $attrs->{XS_CLIENTPORT}) {
		$clientSocket = new IO::Socket::INET(Listen => 1, LocalPort => $clientPort, Reuse => $reuse,
			Proto => 'tcp', LocalAddre => $cleintAddress );
	}
	else {
		$clientSocket = new IO::Socket::INET(Listen => 1, LocalPort => $clientPort, Reuse => $reuse, Proto => 'tcp');
	}
	die "Can't open Client Socket ($!)" unless ($clientSocket);

	$xmlSocketData->{ SERVER }{ $clientSocket } = 1;
	my $ioSelect = new $sel = new IO::Select( $clientSocket );
	if ($childPort and ($childPort != $clientPort)) {
		$childSocket = new IO::Socket::INET(Listen => 1, LocalPort => $childPort, LocalAddr => 'localhost', Reuse => $reuse, Proto => 'tcp' );
		die "Can't open Child Socket ($!)" unless ($childSocket);
		$ioSelect->add($childPort);
		$xmlSocketData->{ SERVER }{ $childSocket } = 1;
	}
	else { $childSocket = $clientPort; $attrs->{XS_CHILDPORT} = $attrs->{XS_CLIENTPORT}; }

	$xmlSocketData->{ IOSELECT }     = $ioSelect;
	$xmlSocketData->{ CHILDSERVER }  = $childSocket;
	$xmlSocketData->{ CLIENTSERVER } = $clientSocket;
}


sub XSCanRead {
	my $self = shift;

	return $self->{ IOSELECT }->can_read();

}

sub XSDisconnect {
	my $self = shift;
	my $sock = shift;

	$xmlSocketData->remove($sock);
	if ($xmlSocketData->{ CHILDSOCKET }{ $sock }) {
		delete $xmlSocketData->{ CHILDSOCKET }{ $sock };
	}
	elsif ($xmlSocketData->{ CLIENTSOCKET }{ $sock }) {
		my $sessionId = $xmlSocketData->{ CLIENTSOCKET }{ $sock }{ sessionid };
		delete $xmlSocketData->{ CLIENTSESSIONID }{ $sessionid };
		delete $xmlSocketData->{ CHILDSOCKET }{ $sock };
	}
	elsif ($xmlSocketData->{ NEWSOCKET }{$sock}) {
		delete $xmlSocketData->{ NEWSOCKET }{ $sock };
		delete $xmlSocketData->{ NEWCHILDSOCKET }{$sock};
		delete $xmlSocketData->{ NEWCLIENTSOCKET }{$sock};
	}
	close $sock;
}

sub XSRead {
	my $self     = shift;
	my $maxSize  = shift;
	my $recSep   = shift;
	my $fh       = shift;

	my $input;
	$fh->input_record_separator($recSep);
	eval
	{
		local $SIG{ALRM} = sub { die ":::alarm::::\n" }; # NB: \n required
		alarm 1;
		$input = $fh->getline();
		alarm 0;
	};
	if ($@) {
		alarm 0;
		if ($@ =~ /:::alarm::::/) { $self->XSDisconnect($@, $fh); return undef; }
		else { $self->XSDisconnect($@, $fh); return undef; }
	}
	else {
		if (length($input) > $recSize) { $self->XSDisconnect("Message to long", $fh); return undef }
	}

	return $input;
}

sub XSConnectClient {
	my $self  = shift;
	my $data  = shift;

	my $sock = $data->{ fileHandle };
	my $attrs = $data->{ attrs };
	my $tree;
	eval { $tree = XMLin ($data->{input}); };
	if ((! $tree) || $@) {
		close $sock;
		return undef;
	}
	elsif (my $userid = $tree->{ userid }) {
		my $password = $tree->{ password };
		my $sessionid = $self->XSOpenSession ({ userid => $userid, password => $password, ipaddress => $sock->peerhost() });
		if ($sessionid) {
			$xmlSocketData->{ CLIENTSOCKET }{ $sock } = { sessionid => $sessionid, attributes => $tree->{myattributes} };
			$xmlSocketData->{ CLIENTSESSIONID }{ $sessionid } = $sock;
		}
		else {
			$xmlSocketData->{ IOSELECT }->remove($sock);
			close $sock;
			return undef;
		}
	}
	else {
		$xmlSocketData->{ IOSELECT }->remove($sock);
		close $sock;
		return undef;
	}
	return 1;
}

sub XSConnectChild {
	my $self = shift;
	my $data = shift;

	my $attrs = $data->{attrs};
	my $sock = $data->{fileHandle};
	my $input = $data->{input};

	if ($sock->peerhost =~ /127\.0\.0\.1/) {
		my $pid;
		($pid = $input) =~ s/.*PID\s*=>\s*([[:digit]]*).*/$1/; 
		if ($xmlSocketData->{ CHILDPID }{$pid}) {
			$xmlSocketData->{ CHILDSOCKET }{ $sock } = { pid => $pid};
			$xmlSocketData->{ IOSELECT }->add($sock);
			return 1;
		}
	}
	$xmlSocketData->{ IOSELECT }->remove($sock);
	close $sock;
	return 1;
}

sub XSChooseChild {
	my $self = shift;

	my $min = undef;
	my $choosed = undef;
	foreach my $sock (keys %{$xmlSocketData->{ CHILDSOCKET }}) {
		$xmlSocketData->{ CHILDSOCKET }{PROCESSINGREQUESTS} ||= 0;
		my $reqCount = $xmlSocketData->{ CHILDSOCKET }{$sock}{PROCESSINGREQUESTS} || 0;
		if ( (! defined($min )) or ($min > $reqCount)) {
			$min = $reqCount;
			$choosed = $sock;
		}
	}
	return ($choosed);
}

sub XSProcessClient {
	my $self = shift;
	my $data = shift;


	my $attrs = $data->{attrs};
	my $clientSock = $data->{fileHandle};
	my $XSHASH;
	eval { $XSHASH = XMLin($data->{input}); };
	return undef if (! $XSHASH or $@);

	my $msgType = $msgTypes { $XSHASH->{MSGTYPE} };

	if ($msgType->{REQUEST}) {
		$XSHASH->{SESSIONID} = $xmlSocketData->{ CLIENTSOCKET }{ $sclientSck }{ sessionid };
		$XSHASH->{USERID} = $xmlSocketData->{ CLIENTSOCKET }{ $sclientSck }{ attributes };
		$XSHASH->{PEERHOST} = $clientSock->peerhost();
		$output = Data::Dumper->Dump([ $XSHASH ], [ 'XSHASH' ]);
		$dest[0] = $self->XSChooseChild();
		eval {
			if ($desc[0]->can_write(0)) {
				print $dest $output, $attrs->{XS_RECSEP};
			}
			else { return "TRY LATER"; }
		};
		if ($@) { return "TRY LATER"; }
		else {
			$xmlSocketData->{ CHILDSOCKET }{PROCESSINGREQUESTS} += 1;
		}
	}
	elsif ($msgType->{BROADCASTCHILDS}) {
		@dest = keys %{$xmlSocketData->{ CHILDSOCKET }};
		$XSHASH->{SESSIONID} = $xmlSocketData->{ CLIENTSOCKET }{ $sclientSck }{ sessionid };
		$XSHASH->{ BROADCASTFROM } = "CLIENT";
		$XSHASH->{USERID} = $xmlSocketData->{ CLIENTSOCKET }{ $sclientSck }{ attributes };
		$XSHASH->{PEERHOST} = $clientSock->peerhost();
		$output = Data::Dumper->Dump([ $XSHASH ], [ 'XSHASH' ]);
		foreach my $dest (@dest) {
			eval {
				if ($dest->can_write()) { print $dest $output, $attrs->{XS_RECSEP}; }
			};
		}
		return "BROADCAST SENT";
	}
	elsif ($msgType->{BROADCASTCLIENTS}) {
		$output = $data->{input};
		if ($XSHASH->{DESTCRITERIA}{ALL}) {
			@dest = keys %{$xmlSocketData->{ CLIENTSOCKET }};
		}
		else {
			foreach my $sock (keys %{$xmlSocketData->{ CLIENTSOCKET }}) {
				my $found = 1;
				my $clientAttrs = $xmlSocketData->{ CLIENTSOCKET }{attributes};
				foreach $attr (keys %{$XSHASH->{DESTCRITERIA}}) {
					my $theAttr = $XSHASH->{DESTCRITERIA}{$attr};
					if ($clientAttrs->{$attr} !~ /$theAttr/) { $found = undef; last; }
				}
				if ($found) { push @dest, $sock; }
			}
		}
		foreach my $dest (@dest) {
			eval {
				if ($dest->can_write()) { print $dest $output, $attrs->{XS_RECSEP}; }
			};
		}
		return "BROADCAST SENT";
	}
	else {
		return "INVALID MESSAGE";
	}
}

sub XSProcessChild {
	my $self = shift;
	my $data = shift;


	my $attrs = $data->{attrs};
	my $XSHASH;
	eval $data->{input};

	my $msgType = $msgTypes { $XSHASH->{MSGTYPE} };

	my $sock = $data->{ fileHandle };
	if ($msgType->{STATUS}) {
		$xmlSocketData->{ CHILDSOCKET }{PROCESSINGREQUESTS} -= 1;
		return "STATUS OK";
	}
	elsif ($msgType->{ GETVAR} ) {
		my $RESPONSE = $self->XSGetVar($XSHASH->{VARNAME}, 'SHARED');
		my $output = Data::Dumper->Dump([ $RESPONSE ], [ 'XSHASH' ]);
		eval { print $sock $output, $attrs->{XS_RECSEP}; };
	}
	elsif ($msgType->{ SETVAR} ) {
		my $RESPONSE = $self->XSGetVar($XSHASH->{VARVAME}, 'SET', $data->{fileHandle}, $XSHASH->{VARVALUE});
		my $output = Data::Dumper->Dump([ $RESPONSE ], [ 'XSHASH' ]);
		eval { print $sock $output, $attrs->{XS_RECSEP}; };
	}
	elsif ($msgType->{ LOCKVAR} ) {
		my $RESPONSE = $self->XSGetVar($XSHASH->{VARNAME}, 'EXCL', $data->{fileHandle});
		my $output = Data::Dumper->Dump([ $RESPONSE ], [ 'XSHASH' ]);
		eval { print $sock $output, $attrs->{XS_RECSEP}; };
	}
	elsif ($msgType->{ UNLOCKVAR} ) {
		my $RESPONSE = $self->XSGetVar($XSHASH->{VARNAME}, 'UNLOCK', $data->{fileHandle});
		my $output = Data::Dumper->Dump([ $RESPONSE ], [ 'XSHASH' ]);
		eval { print $sock $output, $attrs->{XS_RECSEP}; };
	}
	elsif ($msgType->{REPLAY} and $XSHASH->{SESSIONID}) {
		$sock = $self->{CLIENTSESSIONID}{$XSHASH->{SESSIONID}};
		$output = XMLin($XSHASH);
		eval {
			print $sock $output, $attrs->{XS_RECSEP};
		};
		if ($@) { return "TRY LATER"; }
	}
	elsif ($msgType->{BROADCASTCHILDS}) {
		my @dest = ();
		@dest = keys %{$xmlSocketData->{ CHILDSOCKET }};
		$XSHASH->{ BROADCASTFROM } = "CHILD";
		$output = Data::Dumper->Dump([ $XSHASH ], [ 'XSHASH' ]);
		foreach my $dest (@dest) {
			eval {
				print $dest $output, $attrs->{XS_RECSEP};
			};
		}
		return "BROADCAST SENT";
	}
	elsif ($msgType->{BROADCASTCLIENTS}) {
		$XSHASH->{ BROADCASTFROM } = "CHILD";
		$output = XMLin($XSHASH);
		if ($XSHASH->{DESTCRITERIA}{ALL}) {
			@dest = keys %{$xmlSocketData->{ CLIENTSOCKET }};
		}
		else {
			foreach my $sock (keys %{$xmlSocketData->{ CLIENTSOCKET }}) {
				my $found = 1;
				my $clientAttrs = $xmlSocketData->{ CLIENTSOCKET }{attributes};
				foreach $attr (keys %{$XSHASH->{DESTCRITERIA}}) {
					my $theAttr = $XSHASH->{DESTCRITERIA}{$attr};
					if ($clientAttrs->{$attr} !~ /$theAttr/) { $found = undef; last; }
				}
				if ($found) { push @dest, $sock; }
			}
		}
		foreach my $dest (@dest) {
			eval {
				if ($dest->can_write()) { print $dest $output, $attrs->{XS_RECSEP}; }
			};
		}
		return "BROADCAST SENT";
	}
	else {
		return "INVALID MESSAGE";
	}
}

sub XSLoop {
	my $self = shift;
	my $attrs = shift;

	while (1) {
		my @readReady = $self->XSCanRead();
		foreach $sock (@readReady) {
			if ($xmlSocketData->{ SERVER }{ $sock }) {
				my $newClient = $sock->accept();
				if ($self->XSCanAccept ($newClient)) {
					$xmlSocketData->{ NEWSOCKET }{ $newClient } = 1;
					$xmlSocketData->{ IOSELECT }->add($newClient);
					if ($xmlSocketData->{ CHILDSERVER } == $sock) { $xmlSocketData->{ NEWCHILDSOCKET }{$newClient} = 1; }
					elsif ($xmlSocketData->{ CLIENTSERVER } == $sock) { $xmlSocketData->{ NEWCLIENTSOCKET }{$newClient} = 1; }
				}
				else { close $newClient; }
			}
			else {
				my $input;
				if ($xmlSocketData->{ NEWSOCKET }{ $sock }) {
					$input = $sock->XSRead($attrs->{XS_MAXMSGSIZE}, $attrs->{XS_RECSEP}, $sock);
					next unless ($input); # { $self->XSDisconnect($sock); next; }
					if ($xmlSocketData->{ NEWCHILDSOCKET }{$sock}) {
						$self->XSConnectChild({ attrs => $attrs, fileHandle => $sock, input => $input });
					}
					elsif ($xmlSocketData->{ NEWCLIENTSOCKET }{$sock}) {
						$self->XSConnectClient({ attrs => $attrs,  fileHandle => $sock, input => $input });
					}
					else {
						close $newClient;
					}
					delete $xmlSocketData->{ NEWSOCKET }{ $sock };
					delete $xmlSocketData->{ NEWCHILDSOCKET }{$sock};
					delete $xmlSocketData->{ NEWCLIENTSOCKET }{$sock};
				}
				elsif ($xmlSocketData->{ CHILDSOCKET }{ $sock }) {
					$input = $sock->XSReadChild($attrs->{XS_MAXCHILDMSGSIZE}, $attrs->{XS_RECSEP}, $sock);
					next unless ($input); # { $self->XSDisconnect($sock); next; }
					$self->XSProcessClient({ attrs => $attrs, fileHandle => $sock, input => $input });
				}
				elsif ($xmlSocketData->{ CLIENTSOCKET }{ $sock }) {
					$input = $sock->XSReadClient($attrs->{XS_MAXCLIENTMSGSIZE}, $attrs->{XS_RECSEP}, $sock);
					next unless ($input); # { $self->XSDisconnect($sock); next; }
					$self->XSProcessChild({ attrs => $attrs, fileHandle => $sock, input => $input });
				}
				else {
					$xmlSocketData->{ IOSELECT }->remove($sock);
					close ($sock);
				}
			}
		}
	}
}

sub XSFork {
	my $self = shift;
	my $attrs = shift;

	my $count = $attrs->{XS_CHILDCOUNT};
	my $childPort = $attrs->{XS_CHILDPORT};

	for (my $i = 1; $i <= $count; $i++) {
		$pid = fork ();
		die "Can't fork the child number $i ($!)" unless (defined $pid);
		if ($pid) {
			$xmlSocketData{ CHILDPID }{$pid} = 1;
		}
		else {
			$self->XSChildProcess ($attrs);
			exit;
		}
	}
}

sub XmlSocket {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();

	my $attrlist = $objHier->attributelist($self->MyFlowId());
	my $attrs = {};

	foreach my $attr (@$attrlist) {
		$attrs->{$attr->{attrdefid}} = $attr->{attrvalue} if ($attr->{attrdefid});
	}

	$self->XSFork ($attrs); 

	$self->XSOpenSockets ($attrs);

	$self->XSLoop();
}

#### CHILD METHODS ####
sub XSChildProcess {
	my $self = shift;
	my $attrs = shift;

	sleep 10;

	
	my $childPort = $attrs->{XS_CHILDPORT};
	my ($serverSocket);

	$serverSocket = new IO::Socket::INET(PeerPort => $childPort, PeerAddr => 'localhost', Proto => 'tcp' );
	my $ioSelect = new $sel = new IO::Select( $serverSocket );

	while (my @readReady = $self->XSCanRead()) {
		my $sock = shift @readReady;
		$input = $sock->XSRead($attrs->{XS_MAXMSGSIZE}, $attrs->{XS_RECSEP}, $sock);
		if ($input) {
			my $XSHASH = eval ($input);

			if ($@) { $self->XSTerminate($sock, $attrs); }
			
			my $msgType = $msgTypes { $XSHASH->{MSGTYPE} };

			my $script = $XSHASH->{MESSAGE}{SCRIPT};
			my $params = {
					params => $XSHASH->{MESSAGE}{PARAMS},
					sessionid => $XSHASH->{SESSIONID},
			};
			my $result;
			my $replay = { REPLAY => 1, SESSIONID => $XSHASH->{SESSIONID} };

			$self->{XSCLEINTINFO} = {
				SESSIONID     => $XSHASH->{SESSIONID},
				PEERHOST      => $XSHASH->{PEERHOST},
				USERID        => $XSHASH->{USERID},
				MSGTYPE       => $XSHASH->{MSGTYPE},
				BROADCASTFROM => $XSHASH->{ BROADCASTFROM },
			};

			if ($msgType->{REQUEST} || $msgType->{BROADCASTCHILDS}) {
				if ($msgType->{BROADCASTCHILDS}) {
					$params->{ broadcastfrom } = $XSHASH->{ BROADCASTFROM };
				}
				eval { $result = $self->XSExecuteScript ($script, $params, $attrs->{XS_SCRIPTTO}); };
	
				if ($@) {
					$replay->{ ERROR } => 1;
					$replay->{ ERRORMSG } = $@;
					$replay->{ MESSAGE } = '';
				}
				else {
					$replay->{ MESSAGE } = $result;
				}
				if ($msgType->{REQUEST}) {
					$self->XSSendReply($replay, $sock, $attrs);
					$self->XSSendStatus($sock, $attrs);
				}
			}
			elsif ($msgType->{TERMINATE}) {
				$self->XSTerminate($sock, $attrs);
			}
		}
		else {
			$self->XSTerminate();
		}
	}
}

sub XSSendReply {
	my $self = shift;
	my $reply = shift;
	my $sock = shift;
	my $attrs = shift;

	my $output = Data::Dumper->Dump([ $reply ], [ 'XSHASH' ]);
	print $sock $output, $attrs->{XS_RECSEP};
}

sub XSSendStatus {
	my $self = shift;
	my $sock = shift;
	my $attrs = shift;

	my $reply = { STATUS => 1 };
	my $output = Data::Dumper->Dump([ $reply ], [ 'XSHASH' ]);
	print $sock $output, $attrs->{XS_RECSEP};
}

sub XSTerminate {
	my $self = shift;
	my $attrs = shift;

	exit;
}

sub XSExecuteScript {
	my $self = shift;
	my $script = shift;
	my $params = shift;
	my $timeout = shift;

	my $result;
	my $scriptRt = $self->LoadScript ($script);
	eval
	{
		local $SIG{ALRM} = sub { die "XSscript alarm\n"; };
		alarm $timeout;
		$result = $scriptRt->RunScript(@_);
		alarm 0;
	};
	if ($@) {
		alarm 0;
		if ($@ =~ /XSscript alarm/) { die "Script Timeout\n"; }
		else { die $@; }
	}

	return $result;
}

sub XSScrPeerHost {
	my $self = shift;
	return $XmlSocket->{XSCLIENTINFO}{PEERHOST};
}

sub XSScrUserId {
	my $self = shift;

	return $XmlSocket->{XSCLIENTINFO}{PEERHOST};
}

sub XSScrMsgType {
	my $self = shift;

	return $XmlSocket->{XSCLIENTINFO}{MSGTYPE};
}

sub XSScrBroadCastFrom {
	my $self = shift;

	return $XmlSocket->{XSCLIENTINFO}{BROADCASTFROM};
}

package ScriptRt;

sub xspeerhost {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->XSScrPeerHost(@_);
}

sub xsuserid {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->XSScrUserId(@_);
}

sub xsmsgtype {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->XSScrMsgType(@_);
}

sub xsbroadcastfrom {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->XSScrBroadCastFrom(@_);
}

