#!/usr/local/bin/perl
#
# refQry.pm 01/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

use 5.005;
use strict;

package cafQry;

use tools::cafUtils;

sub new {
	my $class = shift;
	$class = ref($class) || $class;
	my $self = shift;

	$self = {} unless defined ($self);
	my $_attr = {
		mylabel  => "undefined",
		columns  => [],
		bindvars => [],
		query    => "",
	};

	$self->{_attr} = $_attr;

	bless $self, $class;
}

sub newfromhash {
	my $class = shift;
	$class = ref($class) || shift;

	my $self = { _attr => shift };

	bless $self, $class;
}
	
sub clear {
	my $self = shift;

	my $newparams = shift || {};

	foreach my $attr (keys %$self) { delete $self->{$attr}; }

	my $_attr = {
		mylabel  => "undefined",
		columns  => [],
		bindvars => [],
		query    => "",
	};

	foreach my $attr(keys %$newparams) { $self->{$attr} = $newparams->{$attr}; }

	$self->{_attr} = $_attr;

	return $self;
}

sub clearspecialattrs {
	my $self = shift;
	my $cat = shift;
	undef unless ($cat);
	$self->{$cat} = undef;
	delete $self->{$cat};
}

sub specialattrs {
	my $self = shift;
	my $cat = shift;
	my $attrname = shift;
	undef unless ($attrname);
	(@_) ? $self->{$cat}{$attrname} = shift : $self->{$cat}{$attrname};
}

sub _attribute {
	my $self = shift;
	my $attrname = shift;

	die "refQry->_attribute : undefined attribute name " unless ($attrname);

	(@_) ? $self->{_attr}{$attrname} = shift : $self->{_attr}{$attrname};
}

sub attribute {
	my $self = shift;
	my $attrname = shift;

	die "refQry->attribute : undefined attribute name " unless ($attrname);

	(@_) ? $self->{$attrname} = shift : $self->{$attrname};
}

sub attributes {
	my $self = shift;

	while (@_) {
		my $attrname = shift;
		$self->{$attrname} = shift if (@_);
	}
}

sub attrs2aref {
	my $self = shift;
	
	my @arr = map { $self->{$_} } @_;

	return \@arr;
}

sub query {
	my $self = shift;

	if (@_) {
		$self->{_attr}{query} = shift;
	}
	$self->{_attr}{query};
}

sub bindvars {
	my $self = shift;

	if (@_) {
		my $bv = shift;
		my @bindvars = @{$bv};
		$self->{_attr}{bindvars} = \@bindvars;
	}
	$self->{_attr}{bindvars};
}

sub bindvarlabels {
	my $self = shift;

	if (@_) {
		my $bvl = shift;
		my @bindvarlabels = @{$bvl};
		$self->{_attr}{bindvarlabels} = \@bindvarlabels;
	}
	$self->{_attr}{bindvarlabels};
}

sub columns {
	my $self = shift;

	if (@_) {
		my $c = shift;
		my @columns = @{$c};
		$self->{_attr}{columns} = \@columns;
	}
	$self->{_attr}{columns};
}

sub mylabel {
	my $self = shift;

	if (@_) {
		$self->{_attr}{mylabel} = shift;
	}
	$self->{_attr}{mylabel}
}

sub orderby {
	shift->_attribute("_orderby", @_);
}

# Array storgae for rows
sub _row {
	my $self = shift;

	my $rowid;
	if (@_) {
		$rowid = shift;
		return undef unless (($rowid <= $self->_attribute("_rowcount")) && ($rowid >= 0));
		$self->_attribute("_currrow", $rowid);
	}
	$rowid = $self->_attribute("_currrow");
	return ($self->{_rows}[$rowid]);
}

sub _nextrow {
	my $self = shift;

	$self->_row( $self->_attribute("_rowcount") + 1);
}

sub _prevrow {
	my $self = shift;

	$self->_row( $self->_attribute("_rowcount") - 1);
}

sub _rows {
	my $self = shift;

	if (@_) {
		my $rows = shift;
		$self->{_rows} = $rows;
		$self->_attribute("_rowcount", $#{$rows});
		$self->_row(0);
	}
	$self->{_rows};
}

sub _pushrow {
	my $self = shift;
	my $row = shift;
	return undef unless ($row);

	$self->{_rows} = [] unless ($self->{_rows});
	push @{$self->{_rows}}, $row;
	my $c = $#{$self->{_rows}};
	$self->_attribute("_rowcount", $c);
	$self->_row($c);

	$self->{_rows};
}

sub rowcount {
	shift->_attribute("_rowcount", @_);
}

# Hash storgae for rows
sub _tohash {
	my $self = shift;

	my $row;

	my $ret = {};

	if (@_) { $row = $self->_row(shift); }
	else { $row = $self->_row(); }

	my $cols = $self->columns();
	my $icol = $#{$cols};

	while ($icol >= 0) { $ret->{$cols->[$icol]} = $row->[$icol]; }

	$ret;
}


sub _hrow {
	my $self = shift;

	my $rowid;
	if (@_) {
		$rowid = shift;
		return undef unless (($rowid <= $self->_attribute("_hrowcount")) && ($rowid >= 0));
		$self->_attribute("_hcurrrow", $rowid);
	}
	$rowid = $self->_attribute("_hcurrrow");
	return ($self->{_hrows}[$rowid]);
}

sub _hnextrow {
	my $self = shift;

	$self->_hrow( $self->_attribute("_hrowcount") + 1);
}

sub _hprevrow {
	my $self = shift;

	$self->_hrow( $self->_attribute("_hrowcount") - 1);
}

sub _hrows {
	my $self = shift;

	if (@_) {
		my $rows = shift;
		$self->{_hrows} = $rows;
		$self->_attribute("_hrowcount", $#{$rows});
		$self->_hrow(0);
	}
	$self->{_hrows};
}

sub _hpushrow {
	my $self = shift;
	my $row = shift;
	return undef unless ($row);

	$self->{_hrows} = [] unless ($self->{_hrows});
	push @{$self->{_hrows}}, $row;
	my $c = $#{$self->{_hrows}};
	$self->_attribute("_hrowcount", $c);
	$self->_hrow($c);

	$self->{_hrows};
}

sub hrowcount {
	shift->_attribute("_hrowcount", @_);
}


# Miscelaneous functions
# sequence management queries
sub snextseq {
	my $p = shift; # self

	$p->{_attr}{mylabel} = "snextseq";
	$p->{_attr}{columns} = [ $p->{seqname} . "_seq" ];
	$p->{_attr}{query} = "select nextval('" . $p->{seqname} . "_seq') as " . $p->{seqname} . "_seq";
}

sub delfromtable {
	my $p = shift;
	my $cond = shift;
	my $where = " where ";

	$p->{_attr}{mylabel} = "delfromtable";
	$p->{_attr}{query} = "delete from " . $p->{tablename};
	$p->{_attr}{bindvars} = [];

	foreach my $elem (@{$cond}) {
		$p->{_attr}{query} .= "$where $elem->[0] $elem->[1] ";
		if (lc($elem->[1]) eq "in") {
			if (ref($elem->[2]) eq "ARRAY") {
				$p->{_attr}{query} .= "(" . join (",", @{$elem->[2]}) . ")";
			}
			else { $p->{_attr}{query} .= $elem->[2]; }
		}
		elsif (lc($elem->[3]) eq "date") {
			$p->{_attr}{query} .= " to_timestamp(?, ?)";
			push @{$p->{_attr}{bindvars}}, $elem->[2], $elem->[4]; 
		}
		else { $p->{_attr}{query} .= " ?"; push @{$p->{_attr}{bindvars}}, $elem->[2]; }
		$where = " and ";
	}

	$p->{_attr}{query};
}
	
sub stablerow {
	my $p = shift;
	my $cond = shift;
	my $fields = shift || '*';
	my $where = " where ";

	$p->{_attr}{mylabel} = "stablerows";
	$p->{_attr}{query} = "select $fields from " . $p->{tablename};
	$p->{_attr}{bindvars} = [];

	foreach my $elem (@{$cond}) {
		$p->{_attr}{query} .= "$where $elem->[0] $elem->[1] ";
		if (lc($elem->[1]) eq "in") {
			if (ref($elem->[2]) eq "ARRAY") {
				$p->{_attr}{query} .= "(" . join (",", @{$elem->[2]}) . ")";
			}
			else { $p->{_attr}{query} .= $elem->[2]; }
		}
		elsif (lc($elem->[3]) eq "date") {
			$p->{_attr}{query} .= " to_timestamp(?, ?)";
			push @{$p->{_attr}{bindvars}}, $elem->[2], $elem->[4]; 
		}
		else { $p->{_attr}{query} .= " ?"; push @{$p->{_attr}{bindvars}}, $elem->[2]; }
		$where = " and ";
	}

	$p->{_attr}{query};
}
	
sub stablerowscount {
	my $p = shift;
	my $cond = shift;
	my $where = " where ";

	$p->{_attr}{mylabel} = "stablerowscount";
	$p->{_attr}{columns} = [ "tablerowscount" ];
	$p->{_attr}{query} = "select count(*) from " . $p->{tablename};
	$p->{_attr}{bindvars} = [];

	foreach my $elem (@{$cond}) {
		if (($elem->[0] eq "groupid") and ($p->{tablename} eq "waddresses")) {
			$p->{_attr}{query} .= " $where addressid in (SELECT addressid FROM waddresslist WHERE groupid = ?)";
			push @{$p->{_attr}{bindvars}}, $elem->[2];
		}
		elsif (ref($elem->[0]) eq "ARRAY") {
			my $or = "";
			$p->{_attr}{query} .= "$where (";
			foreach my $fld (@{$elem->[0]}) {
				$p->{_attr}{query} .= "$or($fld $elem->[1] ?)";
				push @{$p->{_attr}{bindvars}}, $elem->[2];
				$or = " OR ";
			}
			$p->{_attr}{query} .= ")";
		}
		else {
			$p->{_attr}{query} .= "$where $elem->[0] $elem->[1] ";
			if (lc($elem->[1]) eq "in") { $p->{_attr}{query} .= $elem->[2]; }
			elsif (lc($elem->[3]) eq "date") {
				$p->{_attr}{query} .= " to_timestamp(?, ?)";
				push @{$p->{_attr}{bindvars}}, $elem->[2], $elem->[4]; 
			}
			else { $p->{_attr}{query} .= " ?"; push @{$p->{_attr}{bindvars}}, $elem->[2]; }
		}
		$where = " and ";
	}

	$p->{_attr}{query};
}

sub sobjectrowscount {
	my $p = shift;
	my $cond = shift;
#	my $where = " where ";

	$p->{_attr}{mylabel} = "sobjectrowscount";
	$p->{_attr}{columns} = [ "objectrowscount" ];
	$p->{_attr}{query} = "select count(*) from objects, " . $p->{tablename} . " where objects.id = " . $p->{tablename} . ".object_id";
	$p->{_attr}{bindvars} = [];

	foreach my $elem (@{$cond}) {
		if (ref($elem->[0])) {
			$p->{_attr}{query} .= " and (";
			my $or = "";
			foreach my $col (@{$elem->[0]}) {
				$p->{_attr}{query} .= "$or($col $elem->[1] ?)";
				push @{$p->{_attr}{bindvars}}, $elem->[2];
				$or = " or ";
			}
			$p->{_attr}{query} .= ")";
		}
		else {
			$p->{_attr}{query} .= " and $elem->[0] $elem->[1] ";
			if (lc($elem->[1]) eq "in") { $p->{_attr}{query} .= $elem->[2]; }
			elsif (lc($elem->[3]) eq "date") {
				$p->{_attr}{query} .= " to_timestamp(?, ?)";
				push @{$p->{_attr}{bindvars}}, $elem->[2], $elem->[4]; 
			}
			else { $p->{_attr}{query} .= " ?"; push @{$p->{_attr}{bindvars}}, $elem->[2]; }
		}
#		else {
#			$p->{_attr}{query} .= " and $elem->[0] $elem->[1] ?";
#			push @{$p->{_attr}{bindvars}}, $elem->[2];
#		}
#		$where = " and ";
	}

	$p->{_attr}{query};
}

1;
