#!/usr/local/bin/perl
#
# Event.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Event;

@Event::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "object_id" },
	{ fName => "eventid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "genorwait" },
	{ fName => "object_id_source" },
	{ fName => "waitlast" },
	{ fName => "expiredelay" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;

	$self->{search2} = $self->_hiddenvar("_searchCriteria") if ($self->_hiddenvar("_searchCriteria"));
	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ "event_id" , "like", $self->{search1} ];
	}
	if ($self->{search2}) { $cond->[++$icond] = [ "genorwait", "like", $self->{search2} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("objectevents", $cond);
	
	my $query = $dbh->newquery({ event_id => $self->{search1}, genorwait => $self->{search2} });
	$query->seventslist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $query = $dbh->newquery({ object_id => $self->_datavar("object_id") });
	$query->seventslist ();
	my $eventlist = $dbh->hexecfetchall($query, 1);
	$eventlist = [] unless ($eventlist);
	push @$eventlist, ({genorwait => 'generate', expiredelay => 1}, {genorwait => 'generate', expiredelay => 1});
	push @$eventlist, ({genorwait => 'wait', waitlast => "yes"}, {genorwait => 'wait', waitlast => "yes"});

	$query = $dbh->newquery({ object_id => $self->_datavar("object_id") });
	$query->sobject ();
	my $row = $dbh->hexecfetchrow($query, 1);

	$self->{_data} = {};
	foreach my $field (keys %{$row}) { $self->{_data}{$field} = $row->{$field}; }
	
	$self->{_eventslist} = $eventlist;
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");
	my @eventlist;
	my $eventid;
	for (my $i = 0; $i <= 30; $i++) {
#			print "<BR> $i $eventid - ", $cgi->param("object_id_source_$i");
		if ($eventid = $cgi->param("eventid_$i")) {
			$eventid =~ s/[^[:alnum:]]/_/g;
        if ($eventid !~ /^[[:alpha:]]/) { $eventid = "a$eventid"; }
			push @eventlist, {
				object_id => $object_id,
				eventid => $eventid,
				genorwait => $cgi->param("genorwait_$i"),
				object_id_source => $cgi->param("object_id_source_$i") || 0,
				waitlast => $cgi->param("waitlast_$i") || 'no',
				expiredelay => $cgi->param("expiredelay_$i") || 1,
				comments => $cgi->param("comments_$i") || 1,
			};
			
		}
	}

	
	my $ret = $dbh->updatemyevents($object_id, \@eventlist);
	if ($ret > 0) {
		my $query = $dbh->newquery({ object_id => $object_id, currentuser => $self->_hiddenvar("_userid"), });
		$query->uobjectmodified();
		$ret = $dbh->executefinish($query);
	}
	
	if ($ret > 0) { $dbh->commit(); }
	else { $dbh->rollback(); }
	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	$query->dusers();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
