#!/usr/local/bin/perl
#
# Driver.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Driver;

@Driver::ISA = ('cafPage');

# fName => "driverid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "driverid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "driverlabel" },
	{ fName => "protocolid" },
	{ fName => "cantransact" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	my $query = $dbh->newquery();
	$query->sprotocollist();
	$self->{_protocollist} = $dbh->hexecfetchall($query);

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) { $cond->[++$icond] = [ "driverid", "like", $self->{search1} ]; }
	if ($self->{search2}) { $cond->[++$icond] = [ "protocolid", "like", $self->{search2} ]; }
#	print "<BR> - ", join (" - ", @{$cond->[0]});
#	print "<BR> - ", join (" - ", @{$cond->[1]});

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("driver", $cond);
	my $rowscount = $self->_hiddenvar("_rowscount");
	my $lastrow = $self->_hiddenvar("_lastrow");
	my $maxlistdisplay = $conf->maxlistdisplay();
	
	my $query = $dbh->newquery({driverid => $self->{search1}, protocolid => $self->{search2} });
	$query->sdriverlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
#	print "<BR>\nlist1count = $self->{list1count}";
}

sub getmyids {
	my $self = shift;
	my $cgi = shift;

	my $_objectid = $cgi->param("_objectid");
	if (($_objectid) && (! $self->_datavar("driverid"))) {
		my @_ids = split (/-/, $_objectid);
		$self->_datavar("driverid", $_ids[0]);
		$self->_datavar("protocolid", $_ids[1]);
	}
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_getcheckfields ($cgi, $editfields);
	$self->_hiddenvar ("search1", $cgi->param("search1"));

	my $actiondetail = $self->_hiddenvar ("_actiondetail");


	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->getmyids($cgi); }

        $actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ driverid => $self->_datavar("driverid"), protocolid => $self->_datavar("protocolid"), });
		$query->sdriverlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	if ($actiondetail eq 'copy') { $self->_datavar("driverid", undef); }
	if ($actiondetail ne 'new') { $self->_hiddenvar("_protocolidcopy", $self->{_data}{protocolid}); }
	foreach my $proto (@{$self->{_protocollist}}) {
		if ($proto->{protocolid} eq $self->_datavar("protocolid")) { $self->_datavar("protocollabel", $proto->{protocollabel}); }
	}
	$self->_hiddenvar ("_objectid", $self->_datavar("driverid"));
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("protocolid", $cgi->param("_protocolidcopy")) unless ($self->_datavar("protocolid"));
	my $f = $self->_getmyfields();
	my $query = $dbh->newquery($self->_getmyfields());
	$query->idriver();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->getmyids($cgi);
	my $query = $dbh->newquery($self->_getmyfields());
	$query->udriver();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	#$self->_datavar("driverid", $cgi->param("_objectid")) unless ($self->_datavar("driverid"));
	$self->getmyids($cgi);
	my $query = $dbh->newquery($self->_getmyfields());
	$query->ddriver();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
