#!/usr/local/bin/perl
#
# Container.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Container;

@Container::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
#??	{ fName => "id" },
	{ fName => "type" },
	{ fName => "name", fType => "atom", fMand => 1, fMin => 3, fMax => 30 }, 
	{ fName => "parent_id" },
	{ fName => "created" },
	{ fName => "modified" },
	{ fName => "deleted" },
	{ fName => "comments" },
	{ fName => "status" },
	{ fName => "createdby" },
	{ fName => "modifiedby" },
	{ fName => "object_id" },
	{ fName => "objectlabel" },

	{ fName => "externalname", fType => "string", fMand => 1, fMin => 3, fMax => 30 }, 
	{ fName => "externalschema" },
	{ fName => "externaltype" },
	{ fName => "flowdirection", fType => "popup", fMand => 1, fMin => 3, fMax => 30 }, 

#self._data.contextid
#self._data.contextname
#self._data.dbidsn
#self._data.externalname
#self._data.master_id
#self._data.master_id_name
#self._data.name
#self._data.object_id
#self._data.port
#self._data.serverid
#self._data.serverid_name
#self._data.userid
#self._data.userid_name
#	{ fName => "host_address", fType => "ipaddress", fMand => 0, fMin => 3, fMax => 30 },
#	{ fName => "currentuser" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
	$self->{search0} = $cgi->param("search0");
	if ($self->_hiddenvar("_thisconnector", $cgi->param("_thisconnector"))) {
		$self->_hiddenvar("_thisconnector0", $cgi->param("_thisconnector0"));
		$self->{search3} = $self->_hiddenvar("_thisconnector");
		$self->{search0} = $self->_hiddenvar("_thisconnector0");
	}
	else {
		$self->_hiddenvar("_thisconnector", undef);
		$self->_hiddenvar("_thisconnector0", undef);
		($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
		($self->{search0} = $cgi->param("search0"));
	}

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name", "container.externalname" ], "like", $self->{search1} ];
	}
	if ($self->{search2}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search2} ]; }
	if ($self->{search3}) { $self->{search3} =~ s/[^0-9]*//g; $cond->[++$icond] = [ "objects.parent_id", "=", $self->{search3} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("container", $cond, "isobject");
	# my $rowscount = $self->_hiddenvar("_rowscount");
	# my $lastrow = $self->_hiddenvar("_lastrow");
	# my $maxlistdisplay = $conf->maxlistdisplay();
	
	my $query = $dbh->newquery({ name => $self->{search1}, status => $self->{search2}, parent_id => $self->{search3} });
	$query->scontainerlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	my @connectorids;
	foreach my $container (@{$self->{_list1}}) {
		push @connectorids, $container->{parent_id} if ($container->{parent_id});
	}
	my $objectids = $self->_getobjectids(@connectorids);

	foreach my $container (@{$self->{_list1}}) {
		foreach my $connector (@{$objectids}) {
			if ($container->{parent_id} eq $connector->{id}) { $container->{parent_id_name} = $connector->{name}; last; }
		}
	}
			
	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
	# print "<BR>\nlist1count = $self->{list1count}";
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_systemvar("_miscinfo_", '_miscinfo_');
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'container');
#	$self->_datavar("parent_id", -1) unless ($self->_datavar("parent_id"));
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));
	$self->_hiddenvar ("search3", $cgi->param("search3"));
	$self->_hiddenvar ("search0", $cgi->param("search0"));
	if ($self->_hiddenvar("_thisconnector", $cgi->param("_thisconnector"))) {
		$self->_hiddenvar("_thisconnector0", $cgi->param("_thisconnector0"));
		$self->{search3} = $self->_hiddenvar("_thisconnector");
		$self->{search0} = $self->_hiddenvar("_thisconnector0");
	}
	else {
		$self->_hiddenvar("_thisconnector", undef);
		$self->_hiddenvar("_thisconnector0", undef);
		($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
		($self->{search0} = $cgi->param("search0"));
	}

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $query;
	unless ($self->{_system}{noselect}) {
		$query = $dbh->newquery({ object_id => $self->_datavar("object_id"), id => $self->_datavar("object_id"), });
		$self->_datavar("id", $self->_datavar("object_id"));

		$query->scontainerlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

		$query->sobject();
		my $row = $dbh->hexecfetchrow($query, 1);
		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

		my $objectids = $self->_getmyobjectids(qw(parent_id));
	}
	if ($actiondetail eq 'copy') {
		$self->_datavar("copycontainer_id", $self->_datavar("object_id"));
		$self->_datavar("object_id", undef);
	}
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));

	$self->_datavar("rollbackspace", 'no') unless ($self->_datavar("rollbackspace"));
	$self->_datavar("xcreate", 'no') unless ($self->_datavar("xcreate"));
	$self->_datavar("status", 'online') unless ($self->_datavar("status"));
	$self->_datavar("parent_id", undef) unless ($self->_datavar("parent_id") > 0);

	$self->{_attributeslist} = $self->_getmyattributes($dbh);
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $ret;


	$self->_datavar("object_id", $dbh->nextseq("objects"));
	my $bindvars = $self->_getmyfields();
	my $query = $dbh->newquery($bindvars);

	$query->iobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->icontainer();
		$ret = $dbh->executefinish($query);

		if ($ret > 0) {
			my $deepcopy = $cgi->param('deepcopy');
			my $copycontainer_id = $cgi->param('copycontainer_id');
			if (($deepcopy eq "yes") and ($copycontainer_id > 0)) {
				$ret = $dbh->copyfields($self->_datavar("object_id"), $copycontainer_id);
			}
		}
		if ($ret > 0) { $self->_updateattributes(); }
		if ($ret > 0) { $dbh->commit(); }
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	my $ret;

	$query->uobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ucontainer();
		
		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dcontainer();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
