#!/usr/local/bin/perl
#
# Address.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Address;

@Address::ISA = ('cafPage');

# fName => "addressid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "addressid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "addresslabel" },
	{ fName => "addresstype" },
	{ fName => "email" },
	{ fName => "faxnumber" },
	{ fName => "mobilenumber" },
	{ fName => "printercmd" },
	{ fName => "address_line1" },
	{ fName => "address_line2" },
	{ fName => "address_pc" },
	{ fName => "address_city" },
	{ fName => "address_status" },
	{ fName => "modified" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;

	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) { $cond->[++$icond] = [ "addressid", "like", $self->{search1} ]; }
	if ($self->{search2}) { $cond->[++$icond] = [ "addresslabel", "like", $self->{search2} ]; }

	if ($self->{search3}) { $cond->[++$icond] = [ "groupid", "like", $self->{search3} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("waddresses", $cond);
	my $rowscount = $self->_hiddenvar("_rowscount");
	my $lastrow = $self->_hiddenvar("_lastrow");
	my $maxlistdisplay = $conf->maxlistdisplay();
	
	my $addresstype;
	if ($self->_hiddenvar ("_pagetype") eq "SEARCH") { $addresstype = "group"; }
	my $qAttrs = { addressid => $self->{search1}, addresslabel => $self->{search2}, groupid => $self->{search3}, addresstype => $addresstype };
	my $query = $dbh->newquery($qAttrs);
	$query->swaddresseslist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
#	print "<BR>\nlist1count = $self->{list1count}";
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_getcheckfields ($cgi, $editfields);

	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));
	$self->_hiddenvar ("search2", $cgi->param("search3"));

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	if ($actiondetail =~ /^v/) {
		my $i = 0;
		my @groups;
		my $addressid = $self->_datavar("addressid");
		$addressid =~ s/[^[:alnum:]]/_/g;
		$addressid = "Unnamed____" unless ($addressid);
		$addressid = "A_" . $addressid unless ($addressid =~ /^[[:alpha:]]/);
		$addressid = $self->_datavar("addressid", $addressid);


		for($i = 0; my $groupid = $cgi->param("addressid_$i"); $i++) {
			my $oldgroupid = $cgi->param("oldaddressid_$i");
			my $memberstatus = $cgi->param("member_status_$i");
			my $oldmemberstatus = $cgi->param("oldmember_status_$i");
			my $group;
			if (($oldgroupid ne $groupid) or ($memberstatus ne $oldmemberstatus)) {
				$group = {
					addressid => $addressid,
					groupid => $groupid,
					oldgroupid => $oldgroupid,
					member_status => $memberstatus,
					oldmemberstatus => $oldmemberstatus
				};
				push @groups, $group
			}
		}
		$self->{updategroup} = \@groups;

		$self->_initmeth_edit($cgi, $dbh, $conf);
	}
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("addressid", $cgi->param("_objectid")) unless ($self->_datavar("addressid")); }

        $actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ addressid => $self->_datavar("addressid") });
		$query->swaddresseslist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = $row;

		$query->swaddressgroups ();
		$self->{mygroups} = 1;
		my $rows = $dbh->hexecfetchall($query, 1) || [];
		push @$rows, { member_status => "enabled" },{ member_status => "enabled" };
		$self->{_mygroups} = $rows;
		$self->{mygroupscount} = $#$rows;
		
	}
	if ($actiondetail eq 'copy') { $self->_datavar("addressid", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("addressid"));
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $f = $self->_getmyfields();
	my $query = $dbh->newquery($self->_getmyfields());
	$query->iwaddresses();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	my %done = ();

	my $query = $dbh->newquery($self->_getmyfields());
	$query->uwaddresses();

	my $ret = $dbh->executefinish($query);

	if ($ret > 0) {
		my $groups = $self->{updategroup};
		foreach my $group (@$groups) {
			next unless ($group->{groupid} ne $group->{addressid});
			if ($group->{oldgroupid}) {
				$query = $dbh->newquery({ addressid => $group->{addressid}, groupid => $group->{oldgroupid} });
				$query->dwaddressesgroup();
				$ret = $dbh->executefinish($query);
				last unless ($ret > 0);
			}
			if ($group->{groupid} and (!$done{$group->{groupid}})) {
				$query = $dbh->newquery($group);
				$query->iwaddressesgroup();
				$ret = $dbh->executefinish($query);
				$done{$group->{groupid}} = 1;
				last unless ($ret > 0);
			}
		}
	}
				
	if ($ret > 0) { $dbh->commit(); }
	else { $dbh->rollback(); }
	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->daddress();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
