# 2022-10-11 Triage Log

Overall, a fairly quiet week where the change to primary benchmarks ended up breaking exactly even. Secondary benchmarks saw improvements but not in large enough numbers for it to be particularly noteworthy.

Triage done by **@rylev**.
Revision range: [02cd79a..1e926f0](https://perf.rust-lang.org/?start=02cd79afb8080fce8c8ce35533c54d8ecf8f390e&end=1e926f06528ecb2503f026e2fd53cb735d487b10&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.8% | [0.2%, 1.4%] | 19    |
| Regressions ❌ <br /> (secondary) | 1.0% | [0.3%, 1.8%] | 9     |
| Improvements ✅ <br /> (primary) | -0.6% | [-1.8%, -0.3%] | 29    |
| Improvements ✅ <br /> (secondary) | -1.0% | [-6.4%, -0.2%] | 39    |
| All ❌✅ (primary) | -0.0% | [-1.8%, 1.4%] | 48    |


3 Regressions, 1 Improvements, 6 Mixed; 4 of them in rollups
41 artifact comparisons made in total

#### Regressions

Reduce CString allocations in std as much as possible [#93668](https://github.com/rust-lang/rust/pull/93668) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=79a664d8b00505a76b53cfe017b9c80bcee7e080&end=1b225414f325593f974c6b41e671a0a0dc5d7d5e&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.0% | [1.0%, 1.0%] | 4     |
| Regressions ❌ <br /> (secondary) | 0.2% | [0.2%, 0.2%] | 2     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.0% | [1.0%, 1.0%] | 4     |
- The `hello-world` opt benchmarks are dominated by link time. 
- It makes sense that a change to an FFI type `CString` could have an impact on these. 
- I don't think there's a need though to really do anything about it. 


Rollup of 6 pull requests [#102867](https://github.com/rust-lang/rust/pull/102867) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1a7c203e7f89f92598a793c6f6406735c024e7ee&end=e495b37c9a301d776a7bd0c72d5c4a202e159032&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | [0.3%, 0.4%] | 6     |
| Regressions ❌ <br /> (secondary) | 1.4% | [1.2%, 1.6%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary) | 0.3% | [0.3%, 0.4%] | 6     |
- The impacted benchmarks are more sensitive to changes to the trait system, so it looks like it might be [#102845](https://github.com/rust-lang/rust/pull/102845).
- Kicked of a perf run to investigate.


tools/remote-test-{server,client}: Use /data/local/tmp on Android [#102755](https://github.com/rust-lang/rust/pull/102755) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=365578445c6771bb74bfd341c8c48867164a9992&end=1e926f06528ecb2503f026e2fd53cb735d487b10&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | [0.6%, 0.9%] | 6     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.7% | [0.6%, 0.9%] | 6     |
- Looks like Diesel is becoming more noisy lately. You can see that in [this graph](https://user-images.githubusercontent.com/1327285/195131717-d78400d3-218b-4bb2-967a-7faef12b9fbe.png).


#### Improvements

Rewrite representability [#100720](https://github.com/rust-lang/rust/pull/100720) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a688a0305fad9219505a8f2576446510601bafe8&end=bba9785dd73f61aacd301a2cb379e1e85a129047&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | [-0.8%, -0.2%] | 38    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-3.3%, -0.2%] | 21    |
| All ❌✅ (primary) | -0.4% | [-0.8%, -0.2%] | 38    |


#### Mixed

Remove `TypeckResults` from `InferCtxt` [#101632](https://github.com/rust-lang/rust/pull/101632) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e42c4d7218b2596276152c5eb1e69335621f3086&end=43c22af267fd9337bc05382b2771dde49d2e9f26&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | [0.5%, 1.2%] | 13    |
| Regressions ❌ <br /> (secondary) | 4.3% | [3.2%, 5.7%] | 6     |
| Improvements ✅ <br /> (primary) | -0.3% | [-0.6%, -0.2%] | 19    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.6%, -0.2%] | 52    |
| All ❌✅ (primary) | 0.1% | [-0.6%, 1.2%] | 32    |
- Looks `specialization_graph::Children::insert` is getting called way more. 
- Perhaps some strategic placement of `inline` could help help.


Rollup of 6 pull requests [#102787](https://github.com/rust-lang/rust/pull/102787) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43c22af267fd9337bc05382b2771dde49d2e9f26&end=2d3a85b4f8ba7e2554f4d4fee126bc2ac6ee2af4&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | [0.2%, 0.3%] | 2     |
| Regressions ❌ <br /> (secondary) | 1.4% | [1.1%, 1.9%] | 6     |
| Improvements ✅ <br /> (primary) | -0.8% | [-1.0%, -0.4%] | 8     |
| Improvements ✅ <br /> (secondary) | -2.5% | [-3.7%, -0.3%] | 7     |
| All ❌✅ (primary) | -0.6% | [-1.0%, 0.3%] | 10    |
- Most of the regressions are in secondary benchmarks, so I don't think it's worth investigating what caused this.


std: use futex in `Once` [#99505](https://github.com/rust-lang/rust/pull/99505) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eed7f2f58bd44d32ac30e48425eb4bede7ea84f7&end=a688a0305fad9219505a8f2576446510601bafe8&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.5% | [0.5%, 0.5%] | 1     |
| Regressions ❌ <br /> (secondary) | 1.7% | [1.0%, 3.3%] | 7     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 9     |
| All ❌✅ (primary) | 0.5% | [0.5%, 0.5%] | 1     |
- The regression results are small and neutral enough that we don't need to investigate.


Rollup of 8 pull requests [#102809](https://github.com/rust-lang/rust/pull/102809) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bba9785dd73f61aacd301a2cb379e1e85a129047&end=c27948d255167d827421401950c6d723ba28de8f&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | [0.2%, 0.4%] | 13    |
| Regressions ❌ <br /> (secondary) | 0.4% | [0.3%, 0.6%] | 3     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.1%, -1.1%] | 1     |
| All ❌✅ (primary) | 0.3% | [0.2%, 0.4%] | 13    |


Rollup of 6 pull requests [#102875](https://github.com/rust-lang/rust/pull/102875) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8dfb40722da197e77a33a19eb9d3fd6512831341&end=691aeaad6c9ee3483f2851695379b348b8a92a43&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.2% | [0.2%, 0.2%] | 2     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -5.0% | [-6.6%, -1.8%] | 5     |
| All ❌✅ (primary) | 0.2% | [0.2%, 0.2%] | 2     |
- This is neutral enough that I don't believe it warrants investigation.


slice: #[inline] a couple iterator methods. [#96711](https://github.com/rust-lang/rust/pull/96711) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=691aeaad6c9ee3483f2851695379b348b8a92a43&end=0265a3e93bf1b89d97cae113ed214954d5c35e22&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 0.5% | [0.3%, 0.7%] | 4     |
| Improvements ✅ <br /> (primary) | -0.8% | [-1.5%, -0.5%] | 8     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.8%, -1.2%] | 6     |
| All ❌✅ (primary) | -0.8% | [-1.5%, -0.5%] | 8     |
- From the reviewer: "Perf results are more positive than negative, I think that's all that matters for this kind of change. The regressions are minor ones in secondary benchmarks"

