#[cfg(test)]
mod test {
    use netr::*;

    #[test]
    fn test_human_units() {
        assert_eq!(human_unit(1024), "1 KiB");
        assert_eq!(human_unit(1024 * 2), "2 KiB");
        assert_eq!(human_unit(1024 * 1024), "1 MiB");
        assert_eq!(human_unit(1024 * 1024 * 1024), "1 GiB");
        assert_eq!(human_unit(1024 * 1024 * 1024 * 1024), "1 TiB");
        assert_eq!(human_unit(1024 * 1024 * 1024 * 1024 * 1024), "1 PiB");
    }

    #[test]
    fn test_filter_inc() {
        let filter = FilterOpts::create("br0", true).unwrap();

        assert_eq!(filter.clone().matches("br0"), true);
        assert_eq!(filter.clone().matches("docker0"), false);
    }

    #[test]
    fn test_filter_exc() {
        let filter = FilterOpts::create("br0", false).unwrap();

        assert_eq!(filter.clone().matches("br0"), false);
        assert_eq!(filter.clone().matches("docker0"), true);
    }
}
