RabbitMQ `3.10.20` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

This series [**reaches its end of community support** on July 31st, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release **requires Erlang 24.3** and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 and 24 versions older than 24.3 have reached [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ [requires Erlang 24.3.4.8](https://github.com/rabbitmq/rabbitmq-packaging/pull/35)
or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25.3 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).


### Core Server

### Bug Fixes

 * Boot time import of definitions from a `conf.d`-style directory failed unless
   `definitions.skip_if_unchanged` was set to `true`, for example, like in this
   `rabbitmq.conf`:

   ``` ini
   definitions.skip_if_unchanged = false
   definitions.import_backend = local_filesystem
   definitions.local.path = /path/to/RabbitMQ/definitions/conf.d/
   ```

   GitHub issue: [#7705](https://github.com/rabbitmq/rabbitmq-server/pull/7705)

 * Improved resiliency of dead-lettering.

   GitHib issue: [#7677](https://github.com/rabbitmq/rabbitmq-server/pull/7677)


## CLI Tools

### Bug Fixes

 * `rabbitmq-streams help [command]` now looks up stream commands correctly.

   Contributed by @markus812498 (CloudAMQP).

   GitHub issue: [#7657](https://github.com/rabbitmq/rabbitmq-server/pull/7657)


## Management Plugin

### Bug Fixes

 * HTTP API will now respond with a `405 Method Not Allowed` instead of a 500 when
   an unsupported method is used by the client.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#7675](https://github.com/rabbitmq/rabbitmq-server/pull/7675)


### etcd Peer Discovery Plugin

#### Bug Fixes

 * Node key TTL setting was unintentionally ignored.

   GitHub issues: [#7554](https://github.com/rabbitmq/rabbitmq-server/issues/7554)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.20.tar.xz`
instead of the source tarball produced by GitHub.
