% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devutils.R
\name{load_all_file}
\alias{load_all_file}
\title{Generate a Loading Script for Development Packages}
\usage{
load_all_file(path = path.package(package), package, dest = NULL)
}
\arguments{
\item{path}{a character string that contains the path to the development package.}

\item{package}{the name of the package for which the loading script must be generated.
It must be a package that has already been loaded with \link[devtools:load_all]{devtools::load_all} in the current
session, so that its path can be retrieved.}

\item{dest}{the path to script file to create (as a character string).
If not provided, then the script is written in a temporary .R file with prefix
\code{"load_all_<pkgname>_"}.}
}
\value{
a character string that contains the path to the script file.
}
\description{
Writes a script file that contains code that loads a given development package.
}
\details{
This is useful when we want to load a development package in \code{batchtools} registries:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(devtools)
library(batchtools)

load_all("path/to/pkgA")
makeRegistry(..., source = load_all_file("pkgA"))
}\if{html}{\out{</div>}}
}
