if (typeof T === 'undefined') require('../setup');

T('tanh', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).tanh().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('0', 20, 4, '0');
  t('-0', 20, 4, '-0');
  t('Infinity', 40, 4, '1');
  t('-Infinity', 40, 4, '-1');

  t('0.20269', 1, 0, '0.2');
  t('0.42', 6, 5, '0.39693');
  t('-0.35339119', 8, 1, '-0.33937958');
  t('0.153', 8, 1, '0.15181721');
  t('0.26', 1, 1, '0.2');
  t('-0.5', 4, 4, '-0.4621');
  t('0.5301167511', 10, 0, '0.4854703307');
  t('0.1', 6, 2, '0.099668');
  t('-0.1947', 8, 6, '-0.19227651');
  t('0.62055680437965736490569245685566214324448351639', 9, 3, '0.551515589');
  t('0.8653929782497126681556355800799811365862905422680464', 2, 5, '0.7');
  t('-0.223453445837184', 10, 6, '-0.2198071371');
  t('0.6228344', 3, 6, '0.553');
  t('0.3860621505234646348994570686682533147396620957827359578508068456', 2, 1, '0.36');
  t('0.5499', 3, 2, '0.501');
  t('0.27', 4, 0, '0.2637');
  t('-0.20874419', 6, 0, '-0.205765');
  t('-0.9', 9, 0, '-0.716297871');
  t('-0.66', 10, 0, '-0.5783634131');
  t('0.5', 8, 1, '0.46211715');
  t('-0.8730255767917122199088529', 5, 1, '-0.7029');
  t('-0.3', 6, 4, '-0.291313');
  t('0.0772947', 5, 6, '0.077141');
  t('-0.1', 5, 4, '-0.099668');
  t('-0.5530719666927749554276959', 5, 2, '-0.50281');
  t('-0.76695591420216557012230781', 7, 0, '-0.6451559');
  t('-0.28931973768077305489831982152049', 1, 3, '-0.3');
  t('-0.631664433177866683720536966087102', 3, 5, '-0.559');
  t('0.4647093', 9, 2, '0.433914635');
  t('-0.293097', 2, 0, '-0.29');
  t('0.39968', 6, 2, '0.379676');
  t('-0.56478323116711527', 10, 5, '-0.5115177648');
  t('-0.60158', 2, 2, '-0.53');
  t('-0.566', 5, 6, '-0.51242');
  t('-0.5455', 1, 1, '-0.4');
  t('0.181743184255049315571704802510832099', 6, 5, '0.179768');
  t('-0.7', 2, 3, '-0.61');
  t('-0.410626', 8, 6, '-0.38900408');
  t('0.32', 10, 1, '0.3095069212');
  t('0.478', 9, 0, '0.444640449');
  t('-0.2127882653536975970432160655692', 1, 0, '-0.3');
  t('0.668', 9, 2, '0.583662747');
  t('0.1054319768894549379656717', 6, 5, '0.105043');
  t('-0.2159146041935965', 6, 3, '-0.212621');
  t('-0.53', 5, 6, '-0.48538');
  t('0.35', 10, 1, '0.3363755443');
  t('0.3', 3, 2, '0.292');
  t('0.38276035385122733156525463', 1, 1, '0.3');
  t('-0.751550287803356896438162105272645', 31, 0, '-0.6360729215504306567971084126656');
  t('0.2958626290477698111067628542902641468424491987425491552317600599757584700042', 33, 4, '0.287521804057197325874867763687105');
  t('-0.1624241525', 60, 5, '-0.161010729348804314083016365256060397030839070169914629959771');
  t('-0.3246133', 23, 0, '-0.3136723151870226491541');
  t('0.7574510519751273', 52, 2, '0.6395731248592590736391239000170979980280431536354096');
  t('0.52677087', 9, 5, '0.482908861');
  t('0.01504298596871499648833185964254026', 19, 0, '0.01504185137182836531');
  t('-0.66543541401805503420777', 66, 4, '-0.581969286944420744706095110187298812957954793212156080645254407938');
  t('0.016497376645717697522865', 24, 0, '0.0164958801477289569077129');
  t('0.79228702880353249365', 45, 0, '0.659702681921377249169326566285194050648896939');
  t('-0.32047744', 35, 3, '-0.30993856125352144923141124282332793');
  t('0.78607526651121', 28, 5, '0.6561799353543745431928429623');
  t('-0.130782154855323731897567604029773075178369276247566438028657144457559876456195235141546572', 80, 3, '-0.13004158964612601126893011628900193563954656630020761998126577892190799298653838');
  t('0.543888568', 52, 5, '0.495925821522156920755419346170717806152690266078471');
  t('0.595946834719509046130665028731095130596', 61, 0, '0.5341591488247401589317435849855958281981025417248174269032896');
  t('0.8180710003422039739052425209159024776836992576782', 75, 5, '0.674018589934549659108491437885993668870523407722879795457767225797625110655');
  t('0.2002343534718092035', 32, 2, '0.19760053356302078332195382537244');
  t('0.4316', 73, 2, '0.4066575843743152347702788188048559212155195983052915894345749387848887185');
  t('0.0297026', 47, 0, '0.029693868096821512437865399347977108636469769826');
  t('0.53196297398345769364909690685747648864854530119854', 56, 1, '0.48688016788770163925717272861291678368256194265983517854');
  t('-0.86540495196', 57, 4, '-0.699031973057205236065847483268440159156292260431585544883');
  t('-0.0218982341955013979387277630591838547', 66, 6, '-0.021894734560604770532346703409220449766736745588134181835811694617');
  t('-0.3503134189235148094342514029278811316170849354159958798993', 78, 4, '-0.336653471066707838641123262575513511831303224617968974634023553683297404695416');
  t('-0.666924383326373492780403568920198080574', 25, 5, '-0.5829531066013566651422653');
  t('-0.44325150067844726483860902210607088446679462', 1, 1, '-0.4');
  t('0.9034751706768019789827', 60, 6, '0.717985782691067206453512080792613565326893708313975428005223');
  t('0.2172485076904694895179', 63, 4, '0.213894002682974109904624836689545795117673726509639521578182275');
  t('-0.348534855137810830366231027941', 31, 3, '-0.3350755386644384737516713339319');
  t('-0.4255195', 45, 5, '-0.401570102011929569917989543792334637564089692');
  t('-0.886162172614361731', 29, 2, '-0.70949297599079569125232530876');
  t('-0.7', 78, 5, '-0.604367777117163496308687183103826475015566647416860888612419993599538639474122');
  t('0.757119675718', 66, 2, '0.639377257808623037769808128229970838858747391194193471609343942998');
  t('0.2642178764761', 55, 6, '0.2582364046844679768754362197481015404352489557723913895');
  t('0.321329', 74, 6, '0.31070811547650274839857700104600776395241041487409731293147237247772091748');
  t('0.1682695184810800667294209270614384694422368505868903621013683783929', 16, 0, '0.1666991388738522');
  t('-0.409858192536257152668045191854122303323410295894', 43, 0, '-0.3883522664291927890893297914389310714602415');
  t('0.2880615', 120, 0, '0.280349643265659497705660848534086455056558585660980017680059937512840019825269028854239781634733893540906928184561638591');
  t('-0.2803292668048951604355466058306354327579221441238441133669431820221412822995', 69, 4, '-0.2732097971115351269678804248529217531253775527585485646027761857336');
  t('0.209183180524407073852661413214033433796240391516313838917745903006946400344329579472178537414263299679577464721107342550013722994343049', 3, 0, '0.207');
  t('-0.21323411415637447', 100, 3, '-0.2100599987497949082863636944922996664334987508835646248560687414181626030840090573861293885022227807');
  t('-0.934150529137316227495052114810154290011321681684010680698706327964978851230256', 97, 1, '-0.7325231466730630602965757839383259193306031234060675020081884134754348821771511575580397417734494');
  t('0.612797', 135, 6, '0.546092981987055113177270374342598658047265622605927205095448291249934086020550572905344645120234563581014732729130051050396440278747926');
  t('-0.18273791076980028567544728336113017263732539776346366568034574', 45, 2, '-0.180730653506873097396527854034699651896910694');
  t('0.5288356309407208928920467515068426806', 107, 2, '0.48449053794065651739672070077375035256792292259097100512145231251249909428817259447380109781326377031262135');
  t('-0.50752591', 24, 5, '-0.468015268006387507893896');
  t('-0.54917290836787549931392', 88, 4, '-0.49990006636857985687649939062630289074578706968740926592041362893811220431493732027711');
  t('0.91999661041886666', 17, 6, '0.72589581132601256');
});

