This is a set of munin plugins to monitor virtual machines managed via libvirt.

See INSTALL for installation instructions.

Setting things up
=================

Autoconfiguration is simple. Run:

    munin-libvirt-plugins-detect

this will try to detect the hypervisor, create an apropriate configuration and
enable all plugins.

If you prefer to configure things by hand: The default uri used to connect to
libvirt is "qemu:///system". This can be changed in the plugin configuration:

    cat <<EOF >/etc/munin/plugin-conf.d/libvirt
	[libvirt-*]
	env.uri xen:///
	EOF

Enabling plugins by hand is the same as with any other munin plugin:

    ln -s /usr/share/munin/plugins/libvirt-<plugin> /etc/munin/plugins/
    /etc/init.d/munin-node restart

Plugin Configuration
====================

libvirt-mem and libvirt-cputime support [limits][] for critical and warning
values. These are set to 90% (warning) and 95% (critical) by default. However
you can change them in /etc/munin/munin.conf:

    [somehost.example.com]
    libvirt_cputime.total_pc.warning  60
	libvirt_cputime.total_pc.critical 75
	libvirt_mem.total_pc.warning  25
	libvirt_mem.total_pc.critical 50

[limits]: http://munin.projects.linpro.no/wiki/HowToContact
