/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: PlanHints.java 985571 2010-08-14 19:28:26Z jeremias $ */

package org.apache.fop.plan;

/**
 * This interface defines some constants for use in the plan package.
 */
public interface PlanHints {

    /** Border attribute */
    String PLAN_BORDER = "border";
    /** Legend attribute */
    String PLAN_LEGEND = "legend";
    /** Font family attribute */
    String FONT_FAMILY = "font-family";
    /** Font size attribute */
    String FONT_SIZE = "font-size";
    /** Legent type attribute */
    String LEGEND_TYPE = "legendType";
    /** Locale attribute */
    String LOCALE = "locale";
    /** Label type attribute */
    String LABEL_TYPE = "labelType";
    /** Label font size attribute */
    String LABEL_FONT_SIZE = "labelFontSize";
    /** Label font attribute */
    String LABEL_FONT = "labelFont";

}
