complete -c pg_dump --no-files -a '(__fish_complete_pg_database)'

# General options:
complete -c pg_dump -s f -l file -r -d "Output file or directory name"
complete -c pg_dump -s F -l format -x -a "p\t'Plain text' c\t'Custom format' d\t'Directory archive' t\t'Tar archive'" -d "Output file format"
complete -c pg_dump -s j -l jobs -x -d "Number of parallel jobs to dump"
complete -c pg_dump -s v -l verbose -d "Verbose mode"
complete -c pg_dump -s V -l version -d "Output version information"
complete -c pg_dump -s Z -l compress -x -d "Compression level for compressed formats"
complete -c pg_dump -l lock-wait-timeout -x -d "Fail after waiting TIMEOUT for a table lock"
complete -c pg_dump -l no-sync -d "Do not wait for changes to be written safely to disk"
complete -c pg_dump -s '?' -l help -d "Show this help"

# Options controlling the output content:
complete -c pg_dump -s a -l data-only -d "Dump only the data, not the schema"
complete -c pg_dump -s b -l blobs -d "Include large objects in dump"
complete -c pg_dump -s B -l no-blobs -d "Exclude large objects in dump"
complete -c pg_dump -s c -l clean -d "Clean (drop) database objects before recreating"
complete -c pg_dump -s C -l create -d "Include commands to create database in dump"
complete -c pg_dump -s E -l encoding -x -d "Dump the data in encoding ENCODING"
complete -c pg_dump -s n -l schema -x -d "Dump the named schemas only"
complete -c pg_dump -s N -l exclude-schema -x -d "Do NOT dump the named schemas"
complete -c pg_dump -s o -l oids -d "Include OIDs in dump"
complete -c pg_dump -s O -l no-owner -d "Skip restoration of object ownership in plain-text format"
complete -c pg_dump -s s -l schema-only -d "Dump only the schema, no data"
complete -c pg_dump -s S -l superuser -x -d "Superuser user name to use in plain-text format"
complete -c pg_dump -s t -l table -x -d "Dump the named tables only"
complete -c pg_dump -s T -l exclude-table -x -d "Do NOT dump the named tables"
complete -c pg_dump -s x -l no-privileges -d "Do not dump privileges (grant/revoke)"
complete -c pg_dump -l binary-upgrade -d "For use by upgrade utilities only"
complete -c pg_dump -l column-inserts -d "Dump data as INSERT commands with column names"
complete -c pg_dump -l disable-dollar-quoting -d "Disable dollar quoting, use SQL standard quoting"
complete -c pg_dump -l disable-triggers -d "Disable triggers during data-only restore"
complete -c pg_dump -l enable-row-security -d "Enable row security (dump only content user has access to)"
complete -c pg_dump -l exclude-table-data -x -d "Do NOT dump data for the named tables"
complete -c pg_dump -l if-exists -d "Use IF EXISTS when dropping objects"
complete -c pg_dump -l inserts -d "Dump data as INSERT commands, rather than COPY"
complete -c pg_dump -l load-via-partition-root -d "Load partitions via the root table"
complete -c pg_dump -l no-comments -d "Do not dump comments"
complete -c pg_dump -l no-publications -d "Do not dump publications"
complete -c pg_dump -l no-security-labels -d "Do not dump security label assignments"
complete -c pg_dump -l no-subscriptions -d "Do not dump subscriptions"
complete -c pg_dump -l no-synchronized-snapshots -d "Do not use synchronized snapshots in parallel jobs"
complete -c pg_dump -l no-tablespaces -d "Do not dump tablespace assignments"
complete -c pg_dump -l no-unlogged-table-data -d "Do not dump unlogged table data"
complete -c pg_dump -l quote-all-identifiers -d "Quote all identifiers, even if not key words"
complete -c pg_dump -l section -x -a "pre-data data post-data" -d "Dump named section (pre-data, data, or post-data)"
complete -c pg_dump -l serializable-deferrable -d "Wait until the dump can run without anomalies"
complete -c pg_dump -l snapshot -x -d "Use given snapshot for the dump"
complete -c pg_dump -l strict-names -d "Require table/schema include patterns to match entities"
complete -c pg_dump -l use-set-session-authorization -d "Use SET SESSION AUTHORIZATION instead of ALTER OWNER"

# Connection options:
complete -c pg_dump -s d -l dbname -x -a '(__fish_complete_pg_database)' -d "Database to dump"
complete -c pg_dump -s h -l host -x -a '(__fish_print_hostnames)' -d "Database server host or socket directory"
complete -c pg_dump -s p -l port -x -d "Database server port number"
complete -c pg_dump -s U -l username -x -a '(__fish_complete_pg_user)' -d "Connect as specified database user"
complete -c pg_dump -s w -l no-password -d "Never prompt for password"
complete -c pg_dump -s W -l password -d "Force password prompt (should happen automatically)"
complete -c pg_dump -l role -x -d "Do SET ROLE before dump"
