
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * The "getElementsByTagName(name)" method returns a list
 * of all descendant Elements in the order the children
 * were encountered in a pre order traversal of the element
 * tree.
 * Create a NodeList of all the descendant elements
 * using the string "p" as the tagName.
 * The method should return a NodeList whose length is
 * "5" in the order the children were encountered.
 * Access the FOURTH element in the NodeList.  The FOURTH
 * element, the first or second should be an "em" node with
 * the content "EMP0004".
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=246">http://www.w3.org/Bugs/Public/show_bug.cgi?id=246</a>
*/
public final class hc_elementgetelementsbytagnameaccessnodelist extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public hc_elementgetelementsbytagnameaccessnodelist(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elementList;
      Element testEmployee;
      Node firstC;
      String childName;
      int nodeType;
      CharacterData employeeIDNode;
      String employeeID;
      doc = (Document) load("hc_staff", false);
      elementList = doc.getElementsByTagName("p");
      testEmployee = (Element) elementList.item(3);
      firstC = testEmployee.getFirstChild();
      nodeType = (int) firstC.getNodeType();
      
    while (equals(3, nodeType)) {
    firstC = firstC.getNextSibling();
      nodeType = (int) firstC.getNodeType();
      
    }
childName = firstC.getNodeName();
      assertEqualsAutoCase("element", "childName", "em", childName);
        employeeIDNode = (CharacterData) firstC.getFirstChild();
      employeeID = employeeIDNode.getNodeValue();
      assertEquals("employeeID", "EMP0004", employeeID);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/hc_elementgetelementsbytagnameaccessnodelist";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(hc_elementgetelementsbytagnameaccessnodelist.class, args);
   }
}

