/******************************************************************************
 *
 * ALBERTA:  an Adaptive multi Level finite element toolbox  using
 *           Bisectioning refinement and Error control by Residual
 *           Techniques
 *
 * www.alberta-fem.de
 *
 ******************************************************************************
 *
 * File:     alberta-logo.raw.bz2.h
 *
 * Description: raw ALBERTA logo, generated as 64x64 RGBA raw image file,
 *              1 byte per channel, compressed with bzip2. To be fed into
 *              Geomview to generate an on-screen ALBERTA logo.
 *
 *              hexdump -e '12/1 "0x%02x, " "\n"' data > data.h
 *
 ******************************************************************************
 *
 *  author:     Claus-Justus Heine
 *              Abteilung fuer Angewandte Mathematik
 *              Albert-Ludwigs-Universitaet Freiburg
 *              Hermann-Herder-Str. 10
 *              79104 Freiburg
 *              Germany
 *              Claus.Heine@Mathematik.Uni-Freiburg.DE
 *
 *  (c) by C.-J. Heine (2006-2007)
 *
 ******************************************************************************/

#ifndef _ALBERTA_LOGO_H_
#define _ALBERTA_LOGO_H_

#define ALBERTA_LOGO_DATA alberta_logo_raw_bz2
#define ALBERTA_LOGO_SIZE sizeof(ALBERTA_LOGO_DATA)
#define ALBERTA_LOGO_FMT  "raw.bz2"

static const unsigned char alberta_logo_raw_bz2[] = {
  0x42, 0x5a, 0x68, 0x39, 0x31, 0x41, 0x59, 0x26, 0x53, 0x59, 0xda, 0x16,
  0x4e, 0xfc, 0x00, 0x00, 0x3c, 0x7f, 0xff, 0xc8, 0x88, 0x88, 0xa8, 0x80,
  0x88, 0x99, 0x89, 0xc0, 0x09, 0xa8, 0x80, 0x85, 0x8c, 0x0a, 0x8c, 0xc0,
  0x80, 0x89, 0x8c, 0x00, 0x08, 0x80, 0x18, 0x80, 0x40, 0x00, 0x00, 0x80,
  0x08, 0x08, 0x48, 0xd0, 0x04, 0x7b, 0xd0, 0x86, 0xbd, 0x6a, 0x38, 0x14,
  0x68, 0x61, 0x22, 0x10, 0x94, 0xc4, 0x4d, 0x36, 0xa3, 0x01, 0xa8, 0xc9,
  0x90, 0xd1, 0xa6, 0x04, 0xc4, 0xf6, 0xa4, 0x30, 0xd0, 0xd0, 0x00, 0x00,
  0x1a, 0x00, 0x00, 0x00, 0x00, 0x49, 0xa2, 0x55, 0x24, 0x00, 0x00, 0x06,
  0x83, 0x20, 0x00, 0x00, 0x30, 0x8d, 0x41, 0x43, 0x4d, 0x34, 0x30, 0x9a,
  0x61, 0x32, 0x0c, 0x98, 0x23, 0x01, 0x31, 0x0c, 0x10, 0xa5, 0x09, 0x40,
  0xc8, 0x1a, 0x31, 0x34, 0x7a, 0x80, 0x06, 0x43, 0x4d, 0x06, 0x80, 0xfe,
  0x7d, 0xe3, 0xee, 0x04, 0xb3, 0xcd, 0x6e, 0xb3, 0x5d, 0x84, 0x54, 0x57,
  0x67, 0x18, 0x6e, 0xb6, 0xdc, 0x2c, 0x64, 0x9c, 0xa3, 0x21, 0xc8, 0x69,
  0x29, 0x3f, 0xd2, 0x06, 0x15, 0x89, 0x9e, 0xac, 0x1d, 0xc8, 0x89, 0xe1,
  0xe2, 0x82, 0xc5, 0x3c, 0x10, 0xa8, 0xc2, 0xd8, 0xd4, 0x6f, 0x89, 0xda,
  0xec, 0x22, 0xc3, 0x80, 0x34, 0xaa, 0x92, 0x43, 0x21, 0x65, 0xa9, 0x2d,
  0xb3, 0x10, 0xbb, 0x5e, 0xd6, 0x15, 0x24, 0x2a, 0x36, 0x8b, 0x4d, 0x12,
  0x70, 0x06, 0xdd, 0x39, 0xd6, 0xac, 0xa9, 0xb6, 0x99, 0x1d, 0xa1, 0xa4,
  0xdb, 0x34, 0xba, 0x3a, 0xad, 0xd9, 0xd5, 0xa8, 0x69, 0x46, 0x99, 0xda,
  0xb9, 0xb8, 0x71, 0x76, 0x5c, 0x21, 0xa3, 0x2a, 0x3a, 0x49, 0x90, 0x62,
  0x1a, 0x44, 0x54, 0x58, 0x86, 0xa2, 0xa0, 0xed, 0x22, 0x0a, 0x62, 0x29,
  0x20, 0x42, 0x81, 0x28, 0xb0, 0x29, 0x2c, 0x22, 0x21, 0x20, 0x22, 0xc0,
  0xec, 0x8c, 0xd5, 0x51, 0x45, 0x4e, 0x2f, 0x0a, 0x29, 0x09, 0xdd, 0x51,
  0x21, 0x10, 0xd5, 0x45, 0x23, 0x89, 0x44, 0x87, 0xb9, 0xc1, 0x82, 0x71,
  0x40, 0x7e, 0x21, 0x7e, 0xdd, 0x7d, 0x1b, 0x6b, 0xd8, 0x8f, 0x87, 0xd3,
  0x34, 0xe5, 0x82, 0xdc, 0x7f, 0x3b, 0x1b, 0x3e, 0xd2, 0x6f, 0x56, 0x3f,
  0x93, 0xfa, 0x9e, 0x57, 0x77, 0xa2, 0x36, 0x3d, 0xb5, 0x00, 0xcd, 0x5f,
  0x49, 0xe2, 0xa2, 0xec, 0x12, 0x38, 0x44, 0x80, 0xb9, 0x00, 0x08, 0x7d,
  0x2a, 0x29, 0x0a, 0x88, 0x60, 0xa0, 0x03, 0x7b, 0x41, 0x49, 0xe8, 0x41,
  0x00, 0x46, 0xf4, 0x62, 0x00, 0x85, 0x2a, 0xf9, 0x41, 0x15, 0x9f, 0xba,
  0xd2, 0x90, 0x39, 0x98, 0x3a, 0x76, 0xd0, 0x5b, 0x70, 0x39, 0xd9, 0x9e,
  0xb4, 0x84, 0x8d, 0x8d, 0xa0, 0x56, 0x00, 0x4f, 0x84, 0x44, 0x42, 0x7f,
  0x20, 0x04, 0x3b, 0x4a, 0x3b, 0xa7, 0xc1, 0x1b, 0xf7, 0xf7, 0x8d, 0x3b,
  0xfb, 0xf4, 0xe1, 0xd4, 0xcb, 0x38, 0x3d, 0x66, 0x2d, 0x8c, 0x49, 0xfe,
  0x61, 0xa6, 0x7e, 0x38, 0x47, 0x87, 0x5e, 0xbc, 0x56, 0xfc, 0x37, 0xa5,
  0xf4, 0x3f, 0xe8, 0x90, 0x00, 0x9a, 0xcc, 0x48, 0x00, 0xca, 0x9b, 0xa1,
  0x0d, 0xa1, 0xeb, 0xfe, 0x64, 0x2d, 0xdb, 0xb3, 0xf5, 0x26, 0x40, 0x56,
  0xba, 0xe8, 0x9e, 0x6d, 0x30, 0x06, 0xfc, 0x65, 0x28, 0xf6, 0x68, 0xbb,
  0x4d, 0xad, 0xad, 0x28, 0x61, 0x96, 0x89, 0x69, 0xca, 0x35, 0xb9, 0x4c,
  0x35, 0x33, 0x37, 0xb4, 0xcd, 0x38, 0x5f, 0x09, 0xf7, 0xc4, 0xb8, 0xad,
  0xc2, 0x63, 0x46, 0x59, 0x5c, 0xc3, 0xa6, 0x53, 0x86, 0xae, 0xcb, 0xbb,
  0xb4, 0x5e, 0xd6, 0x80, 0x6d, 0x59, 0x05, 0x20, 0xc5, 0xec, 0x5e, 0x5c,
  0x3b, 0xdd, 0xcc, 0x4e, 0x45, 0x48, 0xed, 0x2a, 0x98, 0x36, 0xa2, 0x20,
  0xa6, 0x2b, 0x6f, 0x0e, 0xb6, 0x78, 0x26, 0x6b, 0x9e, 0x40, 0x44, 0xdd,
  0xb1, 0x53, 0xbb, 0xb1, 0x36, 0xdd, 0xd2, 0x9d, 0x4a, 0xc3, 0x0d, 0x29,
  0x65, 0x64, 0xe4, 0xd2, 0xa4, 0x59, 0x98, 0x4e, 0xe0, 0x97, 0x76, 0x09,
  0xd6, 0xc9, 0x95, 0x24, 0x53, 0x92, 0xa3, 0xd4, 0x0e, 0x45, 0xaa, 0x93,
  0x32, 0xa5, 0xea, 0x6d, 0xb0, 0x1c, 0xc0, 0xeb, 0x49, 0xca, 0x9c, 0xc2,
  0xb2, 0x2a, 0xf3, 0x14, 0x59, 0xc3, 0x53, 0x39, 0xaf, 0x5a, 0x2c, 0x33,
  0x0e, 0xb6, 0x61, 0x54, 0x56, 0x15, 0x28, 0x99, 0x83, 0xac, 0xd9, 0xed,
  0x38, 0xea, 0xb5, 0x9d, 0x11, 0x45, 0x0c, 0xba, 0xc7, 0x73, 0x75, 0xd6,
  0x2c, 0xee, 0xbc, 0xca, 0x9a, 0xdc, 0xc9, 0x34, 0xec, 0xb1, 0x95, 0x0a,
  0xa6, 0x5a, 0x0a, 0xa8, 0x41, 0x0d, 0x22, 0x20, 0x21, 0xcc, 0x13, 0x93,
  0x1d, 0x32, 0x5b, 0x2a, 0x29, 0x11, 0x3a, 0x82, 0x9d, 0x19, 0x5a, 0xc5,
  0x58, 0xa9, 0xd5, 0x7b, 0x2a, 0x6a, 0xe2, 0xd5, 0x52, 0x94, 0xa2, 0xb6,
  0xe0, 0x95, 0x84, 0x95, 0x26, 0x40, 0x39, 0x00, 0x59, 0x59, 0x26, 0x48,
  0x1b, 0xac, 0x17, 0x32, 0x02, 0xc9, 0x50, 0x39, 0x20, 0x56, 0x1c, 0x81,
  0xd6, 0x80, 0x69, 0x25, 0x2d, 0x08, 0x50, 0x64, 0x99, 0x29, 0x92, 0xeb,
  0x03, 0x90, 0xb9, 0x0a, 0x64, 0x39, 0x05, 0x00, 0xa8, 0x29, 0x92, 0x19,
  0x81, 0xcd, 0x62, 0xce, 0x61, 0x16, 0x40, 0x58, 0x4c, 0x80, 0x54, 0x25,
  0x64, 0x33, 0xce, 0x61, 0x2b, 0x24, 0xc8, 0x19, 0x87, 0x32, 0x0a, 0x2c,
  0x0c, 0x80, 0x64, 0x8b, 0x2b, 0x52, 0x1c, 0x81, 0xb5, 0x81, 0xcc, 0x33,
  0x52, 0x4a, 0x81, 0x59, 0x32, 0x12, 0x6d, 0x61, 0x32, 0x02, 0xc2, 0x15,
  0x94, 0x64, 0x33, 0x0c, 0x99, 0x08, 0x9f, 0xf8, 0xbb, 0x92, 0x29, 0xc2,
  0x84, 0x86, 0xd0, 0xb2, 0x77, 0xe0
};

#endif


/*
 * Local Variables: ***
 * mode: c ***
 * c-basic-offset: 2 ***
 * End: ***
 */

