.TH "ZIP_FOPEN" "3" "October 23, 2013" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_fopen\fR,
\fBzip_fopen_index\fR
\- open file in zip archive for reading
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIstruct\ zip_file\ *\fR
.br
\fBzip_fopen\fR(\fIstruct zip *archive\fR,\ \fIconst char *fname\fR,\ \fIzip_flags_t flags\fR);
.sp
\fIstruct\ zip_file\ *\fR
.br
\fBzip_fopen_index\fR(\fIstruct zip *archive\fR,\ \fIzip_uint64_t index\fR,\ \fIzip_flags_t flags\fR);
.SH "DESCRIPTION"
The
\fBzip_fopen\fR()
function opens the file name
\fIfname\fR
in
\fIarchive\fR.
The
\fIflags\fR
argument specifies how the name lookup should be done, according to
the values are described in
zip_name_locate(3).
Also, the following values may be
\fIor\fR'ed
to it.
.RS 6n
.TP 19n
\fRZIP_FL_COMPRESSED\fR
Read the compressed data.
Otherwise the data is uncompressed by
\fBzip_fread\fR().
.TP 19n
\fRZIP_FL_UNCHANGED\fR
Read the original data from the zip archive, ignoring any changes made
to the file.
.RE
.PP
The
\fBzip_fopen_index\fR()
function opens the file at position
\fIindex\fR.
.PP
If encrypted data is encountered, the functions call
zip_fopen_encrypted(3)
or
zip_fopen_index_encrypted(3)
respectively, using the default password set with
zip_set_default_password(3).
.SH "RETURN VALUES"
Upon successful completion, a
\fIstruct zip_file\fR
pointer is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
.TP 19n
[\fRZIP_ER_CHANGED\fR]
The file data has been changed.
.TP 19n
[\fRZIP_ER_COMPNOTSUPP\fR]
The compression method used is not supported.
.TP 19n
[\fRZIP_ER_ENCRNOTSUPP\fR]
The encryption method used is not supported.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_NOPASSWD\fR]
The file is encrypted, but no password has been provided.
.TP 19n
[\fRZIP_ER_READ\fR]
A file read error occurred.
.TP 19n
[\fRZIP_ER_SEEK\fR]
A file seek error occurred.
.TP 19n
[\fRZIP_ER_WRONGPASSWD\fR]
The provided password does not match the password used for encryption.
Note that some incorrect passwords are not detected by the check done by
\fBzip_fopen\fR().
.TP 19n
[\fRZIP_ER_ZLIB\fR]
Initializing the zlib stream failed.
.PP
The function
\fBzip_fopen\fR()
may also fail and set
\fIzip_err\fR
for any of the errors specified for the routine
zip_name_locate(3).
.PP
The function
\fBzip_fopen_index\fR()
may also fail with
\fRZIP_ER_INVAL\fR
if
\fIindex\fR
is invalid.
.SH "SEE ALSO"
libzip(3),
zip_fclose(3),
zip_fread(3),
zip_get_num_entries(3),
zip_name_locate(3),
zip_set_default_password(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
