use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('String::Locale::Object');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 16;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	ok( $obj = String::Locale::Object->new(),
		q{$obj = String::Locale::Object->new()}
	);
	isa_ok( $obj, 'String::Locale::Object' );
	ok( $obj = String::Locale::Object->new(
			{   locale  => 'phobos',
				fb      => 'phobos',
				locales => { 'gaudia' => { 'test' => 'test' } }
			}
		),
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => 'phobos', locales => { 'gaudia' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => [],
				fb      => 'phobos',
				locales => { 'gaudia' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => [], fb => 'phobos', locales => { 'gaudia' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => \1,
				fb      => 'phobos',
				locales => { 'gaudia' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => \1, fb => 'phobos', locales => { 'gaudia' => { 'test' => 'test' } } })}
	);
	ok( $obj = String::Locale::Object->new(
			{   locale  => 'phobos',
				locales => { 'gaudia' => { 'test' => 'test' } }
			}
		),
		q{$obj = String::Locale::Object->new({locale => 'phobos', locales => { 'gaudia' => { 'test' => 'test' } }})}
	);
	ok( $obj = String::Locale::Object->new(
			locale  => 'phobos',
			locales => { 'gaudia' => { 'test' => 'test' } }
		),
		q{$obj = String::Locale::Object->new(locale => 'phobos', locales => { 'gaudia' => { 'test' => 'test' } })}
	);
	is_deeply( $obj->fb, 'en', q{$obj->fb} );
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'phobos',
				fb      => [],
				locales => { 'gaudia' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => [], locales => { 'gaudia' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'phobos',
				fb      => \1,
				locales => { 'gaudia' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => \1, locales => { 'gaudia' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'phobos',
				fb      => 'phobos',
				locales => { 'gaudia' => [] }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => 'phobos', locales => { 'gaudia' => [] } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'phobos',
				fb      => 'phobos',
				locales => { 'gaudia' => 'phobos' }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => 'phobos', locales => { 'gaudia' => 'phobos' } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'phobos',
				fb      => 'phobos',
				locales => { 'gaudia' => undef }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => 'phobos', locales => { 'gaudia' => undef } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{ locale => 'phobos', fb => 'phobos', locales => [] } );
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => 'phobos', locales => [] })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{ locale => 'phobos', fb => 'phobos', locales => 'gaudia' } );
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'phobos', fb => 'phobos', locales => 'gaudia' })}
	);
};
subtest 'has fb' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'fb' );
	is_deeply( $obj->fb('penthos'), 'penthos', q{$obj->fb('penthos')} );
	eval { $obj->fb( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb([])} );
	eval { $obj->fb( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb(\1)} );
	is_deeply( $obj->fb, 'penthos', q{$obj->fb} );
};
subtest 'has locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'locale' );
	is_deeply( $obj->locale('nosoi'), 'nosoi', q{$obj->locale('nosoi')} );
	eval { $obj->locale( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale([])} );
	eval { $obj->locale( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale(\1)} );
	is_deeply( $obj->locale, 'nosoi', q{$obj->locale} );
};
subtest '_build_locale' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_build_locale' );
	eval { $obj->_build_locale( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locale([])} );
	eval { $obj->_build_locale( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locale(\1)} );
};
subtest '_set_language_from_locale' => sub {
	plan tests => 5;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_set_language_from_locale' );
	eval { $obj->_set_language_from_locale( [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale([])}
	);
	eval { $obj->_set_language_from_locale( \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale(\1)}
	);
	eval { $obj->_set_language_from_locale() };
	like( $@, qr/undef/, q{$obj->_set_language_from_locale()} );
};
subtest 'has language' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'language' );
	eval { $obj->language( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language([])} );
	eval { $obj->language( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language(\1)} );
};
subtest 'has_language' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'has_language' );
	ok( do { delete $obj->{language}; 1; },
		q{do{ delete $obj->{language}; 1;}}
	);
	is( $obj->has_language, '', q{$obj->has_language} );
	is_deeply( $obj->language('thanatos'),
		'thanatos', q{$obj->language('thanatos')} );
	is( $obj->has_language, 1, q{$obj->has_language} );
};
subtest 'has locales' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'locales' );
	is_deeply(
		$obj->locales( { 'limos' => { 'test' => 'test' } } ),
		{ 'limos' => { 'test' => 'test' } },
		q{$obj->locales({ 'limos' => { 'test' => 'test' } })}
	);
	eval { $obj->locales( { 'limos' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'limos' => [] })}
	);
	eval { $obj->locales( { 'limos' => 'gaudia' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'limos' => 'gaudia' })}
	);
	eval { $obj->locales( { 'limos' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'limos' => undef })}
	);
	eval { $obj->locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales([])} );
	eval { $obj->locales('aporia') };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales('aporia')} );
	is_deeply( $obj->locales, { 'limos' => { 'test' => 'test' } },
		q{$obj->locales} );
};
subtest '_build_locales' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_build_locales' );
	eval { $obj->_build_locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales([])} );
	eval { $obj->_build_locales('phobos') };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales('phobos')}
	);
};
subtest 'convert_locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'convert_locale' );
	eval { $obj->convert_locale( [], 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale([], 'limos')}
	);
	eval { $obj->convert_locale( \1, 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale(\1, 'limos')}
	);
	eval { $obj->convert_locale( 'gaudia', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('gaudia', [])}
	);
	eval { $obj->convert_locale( 'gaudia', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('gaudia', \1)}
	);
};
subtest 'add' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'add' );
	eval { $obj->add( [], { 'gaudia' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add([], { 'gaudia' => { 'test' => 'test' } })}
	);
	eval { $obj->add( \1, { 'gaudia' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add(\1, { 'gaudia' => { 'test' => 'test' } })}
	);
	eval { $obj->add( 'algea', { 'gaudia' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('algea', { 'gaudia' => [] })}
	);
	eval { $obj->add( 'algea', { 'gaudia' => 'geras' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('algea', { 'gaudia' => 'geras' })}
	);
	eval { $obj->add( 'algea', { 'gaudia' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('algea', { 'gaudia' => undef })}
	);
	eval { $obj->add( 'algea', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('algea', [])}
	);
	eval { $obj->add( 'algea', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('algea', 'hypnos')}
	);
};
subtest 'string' => sub {
	plan tests => 10;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'string' );
	eval { $obj->string( [], 'geras', 'aporia', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string([], 'geras', 'aporia', 'hypnos')}
	);
	eval { $obj->string( \1, 'geras', 'aporia', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string(\1, 'geras', 'aporia', 'hypnos')}
	);
	eval { $obj->string( 'penthos', [], 'aporia', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('penthos', [], 'aporia', 'hypnos')}
	);
	eval { $obj->string( 'penthos', \1, 'aporia', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('penthos', \1, 'aporia', 'hypnos')}
	);
	eval { $obj->string( 'penthos', 'geras', [], 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('penthos', 'geras', [], 'hypnos')}
	);
	eval { $obj->string( 'penthos', 'geras', \1, 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('penthos', 'geras', \1, 'hypnos')}
	);
	eval { $obj->string( 'penthos', 'geras', 'aporia', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('penthos', 'geras', 'aporia', [])}
	);
	eval { $obj->string( 'penthos', 'geras', 'aporia', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('penthos', 'geras', 'aporia', \1)}
	);
};
subtest 'DESTROY' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'DESTROY' );
};
subtest 'AUTOLOAD' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'AUTOLOAD' );
};
done_testing();
