#!/usr/bin/perl

package eBay::API::XML::Call::GetCategorySpecifics::GetCategorySpecificsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategorySpecificsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategorySpecifics::GetCategorySpecificsResponseType

=head1 DESCRIPTION

Calls made form seller or buyer find out what the most relevant tags and values are for a given category



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategorySpecifics::GetCategorySpecificsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::CategoryItemSpecificsType;


my @gaProperties = ( [ 'CategoryItemSpecifics', 'ns:CategoryItemSpecificsType', '1'
	     ,'eBay::API::XML::DataType::CategoryItemSpecificsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryItemSpecifics()

Contains the most popular Item Specifics, if any, for a category
specified in the request, or contains information about whether
the recommendations have changed for that category since
the LastUpdateTime you requested. <br>
<br>
The most relevant Item Specifics are returned first. If a name
has multiple values, the first value is more popular.<br>
<br>
This node returns empty (or it's not returned) for a category if
there is no applicable data (such as when you request a parent category, a category that has no popular Item Specifics yet,
or a duplicate category that was already returned).
If you pass in the CategoryID and Name fields together, but no
matching values are found for the name, eBay returns the name
with no values (even if the name is not recommended).<br>
<br>
If custom Item Specifics are enabled for a leaf category you
requested, but GetCategorySpecifics doesn't return any
recommendations for that category, the seller can still
specify their own custom Item Specifics for listings in that category.

#    Argument: reference to an array  
                      of 'ns:CategoryItemSpecificsType'

=cut

sub setCategoryItemSpecifics {
  my $self = shift;
  $self->{'CategoryItemSpecifics'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCategoryItemSpecifics()

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:CategoryItemSpecificsType'

=cut

sub getCategoryItemSpecifics {
  my $self = shift;
  return $self->_getDataTypeArray('CategoryItemSpecifics');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
