# Generated by default/object.tt
package Paws::IoTEventsData::AlarmState;
  use Moose;
  has CustomerAction => (is => 'ro', isa => 'Paws::IoTEventsData::CustomerAction', request_name => 'customerAction', traits => ['NameInRequest']);
  has RuleEvaluation => (is => 'ro', isa => 'Paws::IoTEventsData::RuleEvaluation', request_name => 'ruleEvaluation', traits => ['NameInRequest']);
  has StateName => (is => 'ro', isa => 'Str', request_name => 'stateName', traits => ['NameInRequest']);
  has SystemEvent => (is => 'ro', isa => 'Paws::IoTEventsData::SystemEvent', request_name => 'systemEvent', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEventsData::AlarmState

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEventsData::AlarmState object:

  $service_obj->Method(Att1 => { CustomerAction => $value, ..., SystemEvent => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEventsData::AlarmState object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomerAction

=head1 DESCRIPTION

Contains information about the current state of the alarm.

=head1 ATTRIBUTES


=head2 CustomerAction => L<Paws::IoTEventsData::CustomerAction>

Contains information about the action that you can take to respond to
the alarm.


=head2 RuleEvaluation => L<Paws::IoTEventsData::RuleEvaluation>

Information needed to evaluate data.


=head2 StateName => Str

The name of the alarm state. The state name can be one of the following
values:

=over

=item *

C<DISABLED> - When the alarm is in the C<DISABLED> state, it isn't
ready to evaluate data. To enable the alarm, you must change the alarm
to the C<NORMAL> state.

=item *

C<NORMAL> - When the alarm is in the C<NORMAL> state, it's ready to
evaluate data.

=item *

C<ACTIVE> - If the alarm is in the C<ACTIVE> state, the alarm is
invoked.

=item *

C<ACKNOWLEDGED> - When the alarm is in the C<ACKNOWLEDGED> state, the
alarm was invoked and you acknowledged the alarm.

=item *

C<SNOOZE_DISABLED> - When the alarm is in the C<SNOOZE_DISABLED> state,
the alarm is disabled for a specified period of time. After the snooze
time, the alarm automatically changes to the C<NORMAL> state.

=item *

C<LATCHED> - When the alarm is in the C<LATCHED> state, the alarm was
invoked. However, the data that the alarm is currently evaluating is
within the specified range. To change the alarm to the C<NORMAL> state,
you must acknowledge the alarm.

=back



=head2 SystemEvent => L<Paws::IoTEventsData::SystemEvent>

Contains information about alarm state changes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEventsData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

