# Generated by default/object.tt
package Paws::KinesisVideoArchivedMedia::ClipFragmentSelector;
  use Moose;
  has FragmentSelectorType => (is => 'ro', isa => 'Str', required => 1);
  has TimestampRange => (is => 'ro', isa => 'Paws::KinesisVideoArchivedMedia::ClipTimestampRange', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisVideoArchivedMedia::ClipFragmentSelector

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KinesisVideoArchivedMedia::ClipFragmentSelector object:

  $service_obj->Method(Att1 => { FragmentSelectorType => $value, ..., TimestampRange => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KinesisVideoArchivedMedia::ClipFragmentSelector object:

  $result = $service_obj->Method(...);
  $result->Att1->FragmentSelectorType

=head1 DESCRIPTION

Describes the timestamp range and timestamp origin of a range of
fragments.

Fragments that have duplicate producer timestamps are deduplicated.
This means that if producers are producing a stream of fragments with
producer timestamps that are approximately equal to the true clock
time, the clip will contain all of the fragments within the requested
timestamp range. If some fragments are ingested within the same time
range and very different points in time, only the oldest ingested
collection of fragments are returned.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FragmentSelectorType => Str

The origin of the timestamps to use (Server or Producer).


=head2 B<REQUIRED> TimestampRange => L<Paws::KinesisVideoArchivedMedia::ClipTimestampRange>

The range of timestamps to return.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KinesisVideoArchivedMedia>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

